/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wayoftime.bloodmagic.entity.projectile.EntityMeteor;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.recipe.RecipeMeteor;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;

@RitualRegister(value="meteor")
public class RitualMeteor
extends Ritual {
    public static final String CHECK_RANGE = "itemRange";

    public RitualMeteor() {
        super("ritualMeteor", 0, 25000, "ritual.bloodmagic.meteorRitual");
        this.addBlockRange(CHECK_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1, 1, 1));
        this.setMaximumVolumeAndDistanceOfRange(CHECK_RANGE, 27, 10, 10);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        if (world.field_72995_K) {
            return;
        }
        AreaDescriptor itemRange = masterRitualStone.getBlockRange(CHECK_RANGE);
        List itemList = world.func_217357_a(ItemEntity.class, itemRange.getAABB(masterRitualStone.getMasterBlockPos()));
        for (ItemEntity entityItem : itemList) {
            if (!entityItem.func_70089_S()) continue;
            ItemStack stack = entityItem.func_92059_d();
            RecipeMeteor recipe = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getMeteor(world, stack);
            if (recipe == null) continue;
            int syphonAmount = recipe.getSyphon();
            int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
            if (currentEssence < syphonAmount) {
                return;
            }
            if (syphonAmount > 0) {
                masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(syphonAmount));
            }
            EntityMeteor meteor = new EntityMeteor(world, (double)masterRitualStone.getMasterBlockPos().func_177958_n() + 0.5, masterRitualStone.getMasterBlockPos().func_177956_o() + 30, (double)masterRitualStone.getMasterBlockPos().func_177952_p() + 0.5);
            meteor.func_70016_h(0.0, -0.1, 0.0);
            meteor.setContainedStack(stack.func_77979_a(1));
            world.func_217376_c((Entity)meteor);
            if (stack.func_190926_b()) {
                entityItem.func_70106_y();
            }
            return;
        }
    }

    @Override
    public int getRefreshTime() {
        return 20;
    }

    @Override
    public int getRefreshCost() {
        return 0;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.DUSK);
        this.addCornerRunes(components, 2, 0, EnumRuneType.DUSK);
        this.addOffsetRunes(components, 1, 2, 0, EnumRuneType.DUSK);
        this.addCornerRunes(components, 1, 1, EnumRuneType.DUSK);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualMeteor();
    }
}

