/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.DamageSourceBloodMagic;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="regeneration")
public class RitualRegeneration
extends Ritual {
    public static final String HEAL_RANGE = "heal";
    public static final String VAMPIRE_RANGE = "vampire";
    public static final int SACRIFICE_AMOUNT = 100;
    public static final double corrosiveWillDrain = 0.04;

    public RitualRegeneration() {
        super("ritualRegeneration", 0, 25000, "ritual.bloodmagic.regenerationRitual");
        this.addBlockRange(HEAL_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-15, -15, -15), 31));
        this.addBlockRange(VAMPIRE_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-15, -15, -15), 31));
        this.setMaximumVolumeAndDistanceOfRange(HEAL_RANGE, 0, 20, 20);
        this.setMaximumVolumeAndDistanceOfRange(VAMPIRE_RANGE, 0, 20, 20);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        int maxEffects = currentEssence / this.getRefreshCost();
        int totalEffects = 0;
        int totalCost = 0;
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        double destructiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DESTRUCTIVE, willConfig);
        double vengefulWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.VENGEFUL, willConfig);
        double vengefulDrain = 0.0;
        double steadfastDrain = 0.0;
        double destructiveDrain = 0.0;
        double corrosiveDrain = 0.0;
        boolean syphonHealth = corrosiveWill >= 0.04;
        boolean applyAbsorption = false;
        float absorptionRate = 1.0f;
        int maxAbsorption = 20;
        AreaDescriptor healArea = masterRitualStone.getBlockRange(HEAL_RANGE);
        AxisAlignedBB healRange = healArea.getAABB(pos);
        AreaDescriptor damageArea = masterRitualStone.getBlockRange(VAMPIRE_RANGE);
        AxisAlignedBB damageRange = damageArea.getAABB(pos);
        List entities = world.func_217357_a(LivingEntity.class, healRange);
        List players = world.func_217357_a(PlayerEntity.class, healRange);
        List damagedEntities = world.func_217357_a(LivingEntity.class, damageRange);
        if (syphonHealth) {
            block0: for (PlayerEntity player : players) {
                if (!(player.func_110143_aJ() <= player.func_110138_aP() - 1.0f)) continue;
                float syphonedHealthAmount = this.getSyphonAmountForWill(corrosiveWill);
                Collections.shuffle(damagedEntities);
                for (LivingEntity damagedEntity : damagedEntities) {
                    if (damagedEntity instanceof PlayerEntity) continue;
                    float currentHealth = damagedEntity.func_110143_aJ();
                    damagedEntity.func_70097_a((DamageSource)DamageSourceBloodMagic.INSTANCE, Math.min(player.func_110138_aP() - player.func_110143_aJ(), syphonedHealthAmount));
                    float healthDifference = currentHealth - damagedEntity.func_110143_aJ();
                    if (!(healthDifference > 0.0f)) continue block0;
                    corrosiveDrain += 0.04;
                    corrosiveWill -= 0.04;
                    player.func_70691_i(healthDifference);
                    continue block0;
                }
            }
        }
        for (LivingEntity entity : entities) {
            float health = entity.func_110143_aJ();
            if (health <= entity.func_110138_aP() - 1.0f && entity.func_70687_e(new EffectInstance(Effects.field_76428_l))) {
                if (entity instanceof PlayerEntity) {
                    totalCost += this.getRefreshCost();
                    currentEssence -= this.getRefreshCost();
                } else {
                    totalCost += this.getRefreshCost() / 10;
                    currentEssence -= this.getRefreshCost() / 10;
                }
                entity.func_195064_c(new EffectInstance(Effects.field_76428_l, 50, 0, false, false));
                if (++totalEffects >= maxEffects) break;
            }
            if (!applyAbsorption || !(entity instanceof PlayerEntity) || !applyAbsorption) continue;
            float f = Utils.addAbsorptionToMaximum(entity, absorptionRate, maxAbsorption, 1000);
        }
        if (corrosiveDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.CORROSIVE, corrosiveDrain, true);
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(totalCost));
    }

    @Override
    public int getRefreshTime() {
        return 50;
    }

    @Override
    public int getRefreshCost() {
        return 100;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        components.accept(new RitualComponent(new BlockPos(4, 0, 0), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(5, 0, -1), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(5, 0, 1), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(-4, 0, 0), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(-5, 0, -1), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(-5, 0, 1), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(0, 0, 4), EnumRuneType.FIRE));
        components.accept(new RitualComponent(new BlockPos(1, 0, 5), EnumRuneType.FIRE));
        components.accept(new RitualComponent(new BlockPos(-1, 0, 5), EnumRuneType.FIRE));
        components.accept(new RitualComponent(new BlockPos(0, 0, -4), EnumRuneType.FIRE));
        components.accept(new RitualComponent(new BlockPos(1, 0, -5), EnumRuneType.FIRE));
        components.accept(new RitualComponent(new BlockPos(-1, 0, -5), EnumRuneType.FIRE));
        this.addOffsetRunes(components, 3, 5, 0, EnumRuneType.WATER);
        this.addCornerRunes(components, 3, 0, EnumRuneType.DUSK);
        this.addOffsetRunes(components, 4, 5, 0, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 4, 5, -1, EnumRuneType.EARTH);
        this.addCornerRunes(components, 5, 0, EnumRuneType.EARTH);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualRegeneration();
    }

    public float getSyphonAmountForWill(double corrosiveWill) {
        return 1.0f;
    }
}

