/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile.routing;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;
import wayoftime.bloodmagic.common.item.routing.IItemFilterProvider;
import wayoftime.bloodmagic.common.routing.IInputItemRoutingNode;
import wayoftime.bloodmagic.common.routing.IItemFilter;
import wayoftime.bloodmagic.tile.container.ContainerItemRoutingNode;
import wayoftime.bloodmagic.tile.routing.TileFilteredRoutingNode;
import wayoftime.bloodmagic.util.Utils;

public class TileInputRoutingNode
extends TileFilteredRoutingNode
implements IInputItemRoutingNode,
INamedContainerProvider {
    @ObjectHolder(value="bloodmagic:inputroutingnode")
    public static TileEntityType<TileInputRoutingNode> TYPE;

    public TileInputRoutingNode(TileEntityType<?> type) {
        super(type, 6, "inputnode");
    }

    public TileInputRoutingNode() {
        this(TYPE);
    }

    @Override
    public boolean isInput(Direction side) {
        return true;
    }

    @Override
    public IItemFilter getInputFilterForSide(Direction side) {
        IItemHandler handler;
        TileEntity tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(side));
        if (tile != null && (handler = Utils.getInventory(tile, side.func_176734_d())) != null) {
            ItemStack filterStack = this.getFilterStack(side);
            if (filterStack.func_190926_b() || !(filterStack.func_77973_b() instanceof IItemFilterProvider)) {
                return null;
            }
            IItemFilterProvider filter = (IItemFilterProvider)filterStack.func_77973_b();
            return filter.getInputItemFilter(filterStack, tile, handler);
        }
        return null;
    }

    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
        assert (this.field_145850_b != null);
        return new ContainerItemRoutingNode(this, p_createMenu_1_, p_createMenu_2_);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("Input Routing Node");
    }
}

