/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.brew;

import com.mojang.serialization.Lifecycle;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.brew.ModPotions;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ModBrews {
    public static final RegistryKey<Registry<Brew>> BREW_KEY = RegistryKey.func_240904_a_((ResourceLocation)ResourceLocationHelper.prefix("brews"));
    public static Registry<Brew> registry;
    public static final Brew fallbackBrew;
    public static final Brew speed;
    public static final Brew strength;
    public static final Brew haste;
    public static final Brew healing;
    public static final Brew jumpBoost;
    public static final Brew regen;
    public static final Brew regenWeak;
    public static final Brew resistance;
    public static final Brew fireResistance;
    public static final Brew waterBreathing;
    public static final Brew invisibility;
    public static final Brew nightVision;
    public static final Brew absorption;
    public static final Brew allure;
    public static final Brew soulCross;
    public static final Brew featherfeet;
    public static final Brew emptiness;
    public static final Brew bloodthirst;
    public static final Brew overload;
    public static final Brew clear;

    public static void registerRegistry(RegistryEvent.NewRegistry evt) {
        String fallback = ResourceLocationHelper.prefix("fallback").toString();
        try {
            Method makeBuilder = GameData.class.getDeclaredMethod("makeRegistry", RegistryKey.class, Class.class, String.class);
            makeBuilder.setAccessible(true);
            RegistryBuilder builder = (RegistryBuilder)makeBuilder.invoke(null, BREW_KEY, Brew.class, fallback);
            builder.disableSaving().create();
            registry = GameData.getWrapper(BREW_KEY, (Lifecycle)Lifecycle.experimental(), (String)fallback);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void registerBrews(RegistryEvent.Register<Brew> evt) {
        IForgeRegistry r = evt.getRegistry();
        ModBlocks.register(r, ResourceLocationHelper.prefix("fallback"), fallbackBrew);
        ModBlocks.register(r, "speed", speed);
        ModBlocks.register(r, "strength", strength);
        ModBlocks.register(r, "haste", haste);
        ModBlocks.register(r, "healing", healing);
        ModBlocks.register(r, "jump_boost", jumpBoost);
        ModBlocks.register(r, "regen", regen);
        ModBlocks.register(r, "regen_weak", regenWeak);
        ModBlocks.register(r, "resistance", resistance);
        ModBlocks.register(r, "fire_resistance", fireResistance);
        ModBlocks.register(r, "water_breathing", waterBreathing);
        ModBlocks.register(r, "invisibility", invisibility);
        ModBlocks.register(r, "night_vision", nightVision);
        ModBlocks.register(r, "absorption", absorption);
        ModBlocks.register(r, "overload", overload);
        ModBlocks.register(r, "soul_cross", soulCross);
        ModBlocks.register(r, "feather_feet", featherfeet);
        ModBlocks.register(r, "emptiness", emptiness);
        ModBlocks.register(r, "bloodthirst", bloodthirst);
        ModBlocks.register(r, "allure", allure);
        ModBlocks.register(r, "clear", clear);
    }

    private static Brew make(int cost, EffectInstance ... effects) {
        return new Brew(PotionUtils.func_185181_a(Arrays.asList(effects)), cost, effects);
    }

    static {
        fallbackBrew = new Brew(0, 0, new EffectInstance[0]).setNotBloodPendantInfusable().setNotIncenseInfusable();
        speed = new Brew(5879807, 4000, new EffectInstance(Effects.field_76424_c, 1800, 1));
        strength = new Brew(0xEE3F3F, 4000, new EffectInstance(Effects.field_76420_g, 1800, 1));
        haste = new Brew(16032818, 4000, new EffectInstance(Effects.field_76422_e, 1800, 1));
        healing = new Brew(16735948, 6000, new EffectInstance(Effects.field_76432_h, 1, 1));
        jumpBoost = new Brew(3339373, 4000, new EffectInstance(Effects.field_76430_j, 1800, 1));
        regen = new Brew(16606344, 7000, new EffectInstance(Effects.field_76428_l, 500, 1));
        regenWeak = new Brew(16606344, 9000, new EffectInstance(Effects.field_76428_l, 2400, 0));
        resistance = new Brew(11816471, 4000, new EffectInstance(Effects.field_76429_m, 1800, 1));
        fireResistance = new Brew(16279808, 4000, new EffectInstance(Effects.field_76426_n, 9600, 0));
        waterBreathing = new Brew(8693711, 4000, new EffectInstance(Effects.field_76427_o, 9600, 0));
        invisibility = new Brew(0xAEAEAE, 8000, new EffectInstance(Effects.field_76441_p, 9600, 0)).setNotBloodPendantInfusable();
        nightVision = new Brew(8145899, 4000, new EffectInstance(Effects.field_76439_r, 9600, 0));
        absorption = new Brew(15919907, 7000, new EffectInstance(Effects.field_76444_x, 1800, 3)).setNotBloodPendantInfusable().setNotIncenseInfusable();
        allure = ModBrews.make(2000, new EffectInstance(ModPotions.allure, 4800, 0));
        soulCross = ModBrews.make(10000, new EffectInstance(ModPotions.soulCross, 1800, 0));
        featherfeet = ModBrews.make(7000, new EffectInstance(ModPotions.featherfeet, 1800, 0));
        emptiness = ModBrews.make(30000, new EffectInstance(ModPotions.emptiness, 7200, 0));
        bloodthirst = ModBrews.make(20000, new EffectInstance(ModPotions.bloodthrst, 7200, 0));
        overload = new Brew(0x232323, 12000, new EffectInstance(Effects.field_76420_g, 1800, 3), new EffectInstance(Effects.field_76424_c, 1800, 2), new EffectInstance(Effects.field_76437_t, 3600, 1), new EffectInstance(Effects.field_76438_s, 200, 2));
        clear = ModBrews.make(4000, new EffectInstance(ModPotions.clear, 0, 0));
    }
}

