/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.api.recipes.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.util.StringUtils;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeElvenTrade;
import vazkii.botania.common.integration.crafttweaker.actions.ActionRemoveElvenTradeRecipe;

@Document(value="mods/Botania/ElvenTrade")
@ZenRegister
@IRecipeHandler.For(value=RecipeElvenTrade.class)
@ZenCodeType.Name(value="mods.botania.ElvenTrade")
public class ElvenTradeRecipeManager
implements IRecipeManager,
IRecipeHandler<RecipeElvenTrade> {
    @ZenCodeType.Method
    public void addRecipe(String name, IItemStack[] outputs, IIngredient ... inputs) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)new RecipeElvenTrade(resourceLocation, (ItemStack[])Arrays.stream(outputs).map(IItemStack::getInternal).toArray(ItemStack[]::new), (Ingredient[])Arrays.stream(inputs).map(IIngredient::asVanillaIngredient).toArray(Ingredient[]::new)), ""));
    }

    @ZenCodeType.Method
    public void removeRecipe(IItemStack output) {
        this.removeRecipe(new IItemStack[]{output});
    }

    @ZenCodeType.Method
    public void removeRecipe(IItemStack[] outputs) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveElvenTradeRecipe(this, outputs));
    }

    public IRecipeType<IElvenTradeRecipe> getRecipeType() {
        return ModRecipeTypes.ELVEN_TRADE_TYPE;
    }

    public String dumpToCommandString(IRecipeManager manager, RecipeElvenTrade recipe) {
        StringJoiner s = new StringJoiner(", ", manager.getCommandString() + ".addRecipe(", ");");
        s.add(StringUtils.quoteAndEscape((ResourceLocation)recipe.func_199560_c()));
        s.add(recipe.getOutputs().stream().map(MCItemStackMutable::new).map(MCItemStackMutable::getCommandString).collect(Collectors.joining(", ", "[", "]")));
        recipe.func_192400_c().stream().map(IIngredient::fromIngredient).map(IIngredient::getCommandString).forEach(s::add);
        return s.toString();
    }

    public Optional<Function<ResourceLocation, RecipeElvenTrade>> replaceIngredients(IRecipeManager manager, RecipeElvenTrade recipe, List<IReplacementRule> rules) {
        if (recipe.getOutputs().size() == 1 && recipe.func_192400_c().size() == 1 && recipe.containsItem(recipe.getOutputs().get(0))) {
            return Optional.empty();
        }
        return ReplacementHandlerHelper.replaceNonNullIngredientList(recipe.func_192400_c(), Ingredient.class, (IRecipe)recipe, rules, ingr -> id -> new RecipeElvenTrade((ResourceLocation)id, recipe.getOutputs().toArray(new ItemStack[0]), (Ingredient[])ingr.toArray((Object[])new Ingredient[0])));
    }
}

