/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.api.recipes.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.util.StringUtils;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;
import vazkii.botania.api.recipe.IRuneAltarRecipe;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeRuneAltar;

@Document(value="mods/Botania/RunicAltar")
@ZenRegister
@IRecipeHandler.For(value=RecipeRuneAltar.class)
@ZenCodeType.Name(value="mods.botania.RuneAltar")
public class RuneAltarRecipeManager
implements IRecipeManager,
IRecipeHandler<RecipeRuneAltar> {
    @ZenCodeType.Method
    public void addRecipe(String name, IItemStack output, int mana, IIngredient ... inputs) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)new RecipeRuneAltar(resourceLocation, output.getInternal(), mana, (Ingredient[])Arrays.stream(inputs).map(IIngredient::asVanillaIngredient).toArray(Ingredient[]::new)), ""));
    }

    public IRecipeType<IRuneAltarRecipe> getRecipeType() {
        return ModRecipeTypes.RUNE_TYPE;
    }

    public String dumpToCommandString(IRecipeManager manager, RecipeRuneAltar recipe) {
        StringJoiner s = new StringJoiner(", ", manager.getCommandString() + ".addRecipe(", ");");
        s.add(StringUtils.quoteAndEscape((ResourceLocation)recipe.func_199560_c()));
        s.add(new MCItemStackMutable(recipe.func_77571_b()).getCommandString());
        s.add(String.valueOf(recipe.getManaUsage()));
        recipe.func_192400_c().stream().map(IIngredient::fromIngredient).map(IIngredient::getCommandString).forEach(s::add);
        return s.toString();
    }

    public Optional<Function<ResourceLocation, RecipeRuneAltar>> replaceIngredients(IRecipeManager manager, RecipeRuneAltar recipe, List<IReplacementRule> rules) {
        return ReplacementHandlerHelper.replaceNonNullIngredientList(recipe.func_192400_c(), Ingredient.class, (IRecipe)recipe, rules, ingr -> id -> new RecipeRuneAltar((ResourceLocation)id, recipe.func_77571_b(), recipe.getManaUsage(), (Ingredient[])ingr.toArray((Object[])new Ingredient[0])));
    }
}

