/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.EntityThrownItem;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ModTags;

public class ItemGravityRod
extends Item
implements IManaUsingItem {
    private static final ITag.INamedTag<EntityType<?>> BLACKLIST = ModTags.Entities.SHADED_MESA_BLACKLIST;
    private static final float RANGE = 3.0f;
    private static final int COST = 2;
    private static final Predicate<Entity> CAN_TARGET = e -> !e.func_175149_v() && e.func_70089_S() && !BLACKLIST.func_230235_a_((Object)e.func_200600_R());
    private static final String TAG_TICKS_TILL_EXPIRE = "ticksTillExpire";
    private static final String TAG_TICKS_COOLDOWN = "ticksCooldown";
    private static final String TAG_TARGET = "target";
    private static final String TAG_DIST = "dist";

    public ItemGravityRod(Item.Properties props) {
        super(props);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return newStack.func_77973_b() != this;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        int ticksTillExpire = ItemNBTHelper.getInt(stack, TAG_TICKS_TILL_EXPIRE, 0);
        int ticksCooldown = ItemNBTHelper.getInt(stack, TAG_TICKS_COOLDOWN, 0);
        if (ticksTillExpire == 0) {
            ItemNBTHelper.setInt(stack, TAG_TARGET, -1);
            ItemNBTHelper.setDouble(stack, TAG_DIST, -1.0);
        }
        if (ticksCooldown > 0) {
            --ticksCooldown;
        }
        if (ticksTillExpire >= 0) {
            --ticksTillExpire;
        }
        ItemNBTHelper.setInt(stack, TAG_TICKS_TILL_EXPIRE, ticksTillExpire);
        ItemNBTHelper.setInt(stack, TAG_TICKS_COOLDOWN, ticksCooldown);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        ItemGravityRod.leftClick(player);
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        return ItemNBTHelper.getInt(stack, TAG_TICKS_TILL_EXPIRE, 0) != 0;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int targetID = ItemNBTHelper.getInt(stack, TAG_TARGET, -1);
        int ticksCooldown = ItemNBTHelper.getInt(stack, TAG_TICKS_COOLDOWN, 0);
        double length = ItemNBTHelper.getDouble(stack, TAG_DIST, -1.0);
        if (ticksCooldown == 0) {
            Entity target = null;
            if (targetID != -1 && player.field_70170_p.func_73045_a(targetID) != null) {
                Entity taritem = player.field_70170_p.func_73045_a(targetID);
                boolean found = false;
                Vector3 targetVec = Vector3.fromEntityCenter((Entity)player);
                List entities = new ArrayList();
                for (int distance = 1; entities.size() == 0 && distance < 25; ++distance) {
                    targetVec = targetVec.add(new Vector3(player.func_70040_Z()).multiply(distance)).add(0.0, 0.5, 0.0);
                    entities = player.field_70170_p.func_175674_a((Entity)player, targetVec.boxForRange(3.0), CAN_TARGET);
                    if (!entities.contains(taritem)) continue;
                    found = true;
                }
                if (found) {
                    target = player.field_70170_p.func_73045_a(targetID);
                }
            }
            if (target == null) {
                Vector3 targetVec = Vector3.fromEntityCenter((Entity)player);
                List entities = new ArrayList();
                for (int distance = 1; entities.size() == 0 && distance < 25; ++distance) {
                    targetVec = targetVec.add(new Vector3(player.func_70040_Z()).multiply(distance)).add(0.0, 0.5, 0.0);
                    entities = player.field_70170_p.func_175674_a((Entity)player, targetVec.boxForRange(3.0), CAN_TARGET);
                }
                if (entities.size() > 0) {
                    target = (Entity)entities.get(0);
                    length = 5.5;
                    if (target instanceof ItemEntity) {
                        length = 2.0;
                    }
                }
            }
            if (target != null) {
                if (BLACKLIST.func_230235_a_((Object)target.func_200600_R())) {
                    return ActionResult.func_226251_d_((Object)stack);
                }
                if (ManaItemHandler.instance().requestManaExactForTool(stack, player, 2, true)) {
                    if (target instanceof ItemEntity) {
                        ((ItemEntity)target).func_174867_a(5);
                    }
                    if (target instanceof LivingEntity) {
                        LivingEntity targetEntity = (LivingEntity)target;
                        targetEntity.field_70143_R = 0.0f;
                        if (targetEntity.func_70660_b(Effects.field_76421_d) == null) {
                            targetEntity.func_195064_c(new EffectInstance(Effects.field_76421_d, 2, 3, true, true));
                        }
                    }
                    Vector3 target3 = Vector3.fromEntityCenter((Entity)player).add(new Vector3(player.func_70040_Z()).multiply(length)).add(0.0, 0.5, 0.0);
                    if (target instanceof ItemEntity) {
                        target3 = target3.add(0.0, 0.25, 0.0);
                    }
                    for (int i = 0; i < 4; ++i) {
                        float r = 0.5f + (float)Math.random() * 0.5f;
                        float b = 0.5f + (float)Math.random() * 0.5f;
                        float s = 0.2f + (float)Math.random() * 0.1f;
                        float m = 0.1f;
                        float xm = ((float)Math.random() - 0.5f) * m;
                        float ym = ((float)Math.random() - 0.5f) * m;
                        float zm = ((float)Math.random() - 0.5f) * m;
                        WispParticleData data = WispParticleData.wisp(s, r, 0.0f, b);
                        world.func_195594_a((IParticleData)data, target.func_226277_ct_() + (double)(target.func_213311_cf() / 2.0f), target.func_226278_cu_() + (double)(target.func_213302_cg() / 2.0f), target.func_226281_cx_() + (double)(target.func_213311_cf() / 2.0f), (double)xm, (double)ym, (double)zm);
                    }
                    MathHelper.setEntityMotionFromVector(target, target3, 0.3333333f);
                    ItemNBTHelper.setInt(stack, TAG_TARGET, target.func_145782_y());
                    ItemNBTHelper.setDouble(stack, TAG_DIST, length);
                }
                ItemNBTHelper.setInt(stack, TAG_TICKS_TILL_EXPIRE, 5);
                return ActionResult.func_226249_b_((Object)stack);
            }
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    private static void leftClick(PlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() == ModItems.gravityRod) {
            int targetID = ItemNBTHelper.getInt(stack, TAG_TARGET, -1);
            ItemNBTHelper.getDouble(stack, TAG_DIST, -1.0);
            if (targetID != -1 && player.field_70170_p.func_73045_a(targetID) != null) {
                Entity taritem = player.field_70170_p.func_73045_a(targetID);
                boolean found = false;
                Vector3 target = Vector3.fromEntityCenter((Entity)player);
                List entities = new ArrayList();
                for (int distance = 1; entities.size() == 0 && distance < 25; ++distance) {
                    target = target.add(new Vector3(player.func_70040_Z()).multiply(distance)).add(0.0, 0.5, 0.0);
                    entities = player.field_70170_p.func_175674_a((Entity)player, target.boxForRange(3.0), CAN_TARGET);
                    if (!entities.contains(taritem)) continue;
                    found = true;
                }
                if (found) {
                    Entity item = taritem;
                    ItemNBTHelper.setInt(stack, TAG_TARGET, -1);
                    ItemNBTHelper.setDouble(stack, TAG_DIST, -1.0);
                    Vector3 moveVector = new Vector3(player.func_70040_Z().func_72432_b());
                    if (item instanceof ItemEntity) {
                        ((ItemEntity)item).func_174867_a(20);
                        float mot = IManaProficiencyArmor.hasProficiency(player, stack) ? 2.25f : 1.5f;
                        item.func_213293_j(moveVector.x * (double)mot, moveVector.y, moveVector.z * (double)mot);
                        if (!player.field_70170_p.field_72995_K) {
                            EntityThrownItem thrown = new EntityThrownItem(item.field_70170_p, item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_(), (ItemEntity)item);
                            item.field_70170_p.func_217376_c((Entity)thrown);
                        }
                        item.func_70106_y();
                    } else {
                        item.func_213317_d(moveVector.multiply(3.0, 1.5, 3.0).toVector3d());
                    }
                    ItemNBTHelper.setInt(stack, TAG_TICKS_COOLDOWN, 10);
                }
            }
        }
    }
}

