/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.mixin;

import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.botania.common.Botania;
import vazkii.botania.common.item.equipment.tool.elementium.ItemElementiumPick;

@Mixin(value={LootTable.class})
public class MixinLootTable {
    private static final ResourceLocation GOG_SEEDS = new ResourceLocation("gardenofglass", "extra_seeds");
    @Unique
    private boolean callingGogTable;

    @Inject(at={@At(value="RETURN")}, method={"generate(Lnet/minecraft/loot/LootContext;Ljava/util/function/Consumer;)V"})
    private void addGogSeeds(LootContext context, Consumer<ItemStack> stacksOut, CallbackInfo ci) {
        if (Botania.gardenOfGlassLoaded && !this.callingGogTable) {
            this.callingGogTable = true;
            context.func_227502_a_(GOG_SEEDS).func_216120_b(context, stacksOut);
            this.callingGogTable = false;
        }
    }

    @ModifyArg(method={"generate(Lnet/minecraft/loot/LootContext;Ljava/util/function/Consumer;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/loot/LootTable;recursiveGenerate(Lnet/minecraft/loot/LootContext;Ljava/util/function/Consumer;)V"))
    private Consumer<ItemStack> filterDisposables(LootContext context, Consumer<ItemStack> inner) {
        return stack -> {
            Entity e = (Entity)context.func_216031_c(LootParameters.field_216281_a);
            ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
            if (e != null && tool != null && ItemElementiumPick.shouldFilterOut(e, tool, stack)) {
                return;
            }
            inner.accept((ItemStack)stack);
        };
    }
}

