/*
 * Decompiled with CFR 0.152.
 */
package L_Ender.cataclysm.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class Boss_monster
extends MonsterEntity
implements IAnimatedEntity {
    private int animationTick;
    private Animation currentAnimation;
    protected boolean dropAfterDeathAnim = true;
    private int killDataRecentlyHit;
    private DamageSource killDataCause;
    private PlayerEntity killDataAttackingPlayer;

    public Boss_monster(EntityType entity, World world) {
        super(entity, world);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        boolean attack = super.func_70097_a(source, damage);
        if (attack && this.func_110143_aJ() <= 0.0f) {
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, this.getDeathAnimation());
        }
        return attack;
    }

    double calculateRange(DamageSource damagesource) {
        return damagesource.func_76346_g() != null ? this.func_70068_e(damagesource.func_76346_g()) : -1.0;
    }

    public double getAngleBetweenEntities(Entity first, Entity second) {
        return Math.atan2(second.func_226281_cx_() - first.func_226281_cx_(), second.func_226277_ct_() - first.func_226277_ct_()) * 57.29577951308232 + 90.0;
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.field_70170_p.func_175647_a(entityClass, this.func_174813_aQ().func_72314_b(dX, dY, dZ), e -> e != this && (double)this.func_70032_d((Entity)e) <= r + (double)(e.func_213311_cf() / 2.0f) && e.func_226278_cu_() <= this.func_226278_cu_() + dY);
    }

    public static void disableShield(LivingEntity livingEntity, int ticks) {
        ((PlayerEntity)livingEntity).func_184811_cZ().func_185145_a(livingEntity.func_184607_cu().func_77973_b(), ticks);
        livingEntity.func_184602_cy();
        livingEntity.field_70170_p.func_72960_a((Entity)livingEntity, (byte)30);
    }

    public static void entityHitAngle(LivingEntity livingEntity, int arc, int range) {
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.func_110143_aJ() <= 0.0f) {
            Animation death = this.getDeathAnimation();
            if (death != null) {
                this.onDeathUpdate(death.getDuration() - 20);
            } else {
                this.onDeathUpdate(20);
            }
        }
    }

    protected void onDeathAIUpdate() {
    }

    protected final void func_70609_aI() {
    }

    private void onDeathUpdate(int deathDuration) {
        this.onDeathAIUpdate();
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == deathDuration) {
            this.field_70717_bb = this.killDataAttackingPlayer;
            this.field_70718_bc = this.killDataRecentlyHit;
            if (!this.field_70170_p.func_201670_d() && this.dropAfterDeathAnim && this.killDataCause != null) {
                this.func_213345_d(this.killDataCause);
            }
            this.remove(false);
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)cause)) {
            return;
        }
        if (!this.field_70729_aU) {
            Entity entity = cause.func_76346_g();
            LivingEntity livingentity = this.func_94060_bK();
            if (this.field_70744_aE >= 0 && livingentity != null) {
                livingentity.func_191956_a((Entity)this, this.field_70744_aE, cause);
            }
            if (this.func_70608_bn()) {
                this.func_213366_dy();
            }
            this.field_70729_aU = true;
            this.func_110142_aN().func_94549_h();
            if (this.field_70170_p instanceof ServerWorld) {
                if (entity != null) {
                    entity.func_241847_a((ServerWorld)this.field_70170_p, (LivingEntity)this);
                }
                if (!this.dropAfterDeathAnim) {
                    this.func_213345_d(cause);
                }
                this.func_226298_f_(livingentity);
            }
            this.killDataCause = cause;
            this.killDataRecentlyHit = this.field_70718_bc;
            this.killDataAttackingPlayer = this.field_70717_bb;
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_213301_b(Pose.DYING);
        }
    }

    public void circleEntity(Entity target, float radius, float speed, boolean direction, int circleFrame, float offset, float moveSpeedMultiplier) {
        int directionInt = direction ? 1 : -1;
        double t = (double)(directionInt * circleFrame) * 0.5 * (double)speed / (double)radius + (double)offset;
        Vector3d movePos = target.func_213303_ch().func_72441_c((double)radius * Math.cos(t), 0.0, (double)radius * Math.sin(t));
        this.func_70661_as().func_75492_a(movePos.func_82615_a(), movePos.func_82617_b(), movePos.func_82616_c(), (double)(speed * moveSpeedMultiplier));
    }

    protected void repelEntities(float x, float y, float z, float radius) {
        List<LivingEntity> nearbyEntities = this.getEntityLivingBaseNearby(x, y, z, radius);
        for (Entity entity : nearbyEntities) {
            if (!entity.func_70067_L() || entity.field_70145_X) continue;
            double angle = (this.getAngleBetweenEntities((Entity)this, entity) + 90.0) * Math.PI / 180.0;
            entity.func_213293_j(-0.1 * Math.cos(angle), entity.func_213322_ci().field_72448_b, -0.1 * Math.sin(angle));
        }
    }

    public boolean canBePushedByEntity(Entity entity) {
        return true;
    }

    public void func_70108_f(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!(this.func_70608_bn() || this.func_184223_x(entityIn) || entityIn.field_70145_X || this.field_70145_X || !((d2 = MathHelper.func_76132_a((double)(d0 = entityIn.func_226277_ct_() - this.func_226277_ct_()), (double)(d1 = entityIn.func_226281_cx_() - this.func_226281_cx_()))) >= (double)0.01f))) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            d0 *= (double)(1.0f - this.field_70144_Y);
            d1 *= (double)(1.0f - this.field_70144_Y);
            if (!this.func_184207_aI() && this.canBePushedByEntity(entityIn)) {
                this.func_70024_g(-d0, 0.0, -d1);
            }
            if (!entityIn.func_184207_aI()) {
                entityIn.func_70024_g(d0, 0.0, d1);
            }
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION};
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    @Nullable
    public Animation getDeathAnimation() {
        return null;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    protected boolean func_225511_J_() {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }
}

