/*
 * Decompiled with CFR 0.152.
 */
package L_Ender.cataclysm.entity;

import L_Ender.cataclysm.cataclysm;
import L_Ender.cataclysm.config.CMConfig;
import L_Ender.cataclysm.entity.AI.CmAttackGoal;
import L_Ender.cataclysm.entity.Boss_monster;
import L_Ender.cataclysm.entity.Ender_Golem_Entity;
import L_Ender.cataclysm.entity.Endermaptera_Entity;
import L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import L_Ender.cataclysm.entity.etc.GroundPathNavigatorWide;
import L_Ender.cataclysm.entity.etc.SmartBodyHelper2;
import L_Ender.cataclysm.entity.projectile.Ender_Guardian_Bullet_Entity;
import L_Ender.cataclysm.entity.projectile.Void_Rune_Entity;
import L_Ender.cataclysm.init.ModSounds;
import L_Ender.cataclysm.init.ModTag;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class Ender_Guardian_Entity
extends Boss_monster {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    private static final DataParameter<Boolean> IS_HELMETLESS = EntityDataManager.func_187226_a(Ender_Guardian_Entity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_AWAKEN = EntityDataManager.func_187226_a(Ender_Guardian_Entity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> USED_MASS_DESTRUCTION = EntityDataManager.func_187226_a(Ender_Guardian_Entity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final Animation GUARDIAN_RIGHT_STRONG_ATTACK = Animation.create((int)60);
    public static final Animation GUARDIAN_LEFT_STRONG_ATTACK = Animation.create((int)60);
    public static final Animation GUARDIAN_RIGHT_ATTACK = Animation.create((int)40);
    public static final Animation GUARDIAN_LEFT_ATTACK = Animation.create((int)40);
    public static final Animation GUARDIAN_BURST_ATTACK = Animation.create((int)53);
    public static final Animation GUARDIAN_UPPERCUT_AND_BULLET = Animation.create((int)100);
    public static final Animation GUARDIAN_RAGE_UPPERCUT = Animation.create((int)120);
    public static final Animation GUARDIAN_STOMP = Animation.create((int)48);
    public static final Animation GUARDIAN_RAGE_STOMP = Animation.create((int)83);
    public static final Animation GUARDIAN_MASS_DESTRUCTION = Animation.create((int)75);
    public static final Animation GUARDIAN_FALLEN = Animation.create((int)196);
    public static final int STOMP_COOLDOWN = 400;
    public float deactivateProgress;
    public float prevdeactivateProgress;
    public boolean Breaking = CMConfig.EnderguardianBlockBreaking;
    private int stomp_cooldown = 0;

    public Ender_Guardian_Entity(EntityType entity, World world) {
        super(entity, world);
        this.field_70728_aV = 300;
        this.field_70138_W = 1.5f;
        this.dropAfterDeathAnim = true;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, GUARDIAN_RIGHT_STRONG_ATTACK, GUARDIAN_LEFT_STRONG_ATTACK, GUARDIAN_BURST_ATTACK, GUARDIAN_UPPERCUT_AND_BULLET, GUARDIAN_STOMP, GUARDIAN_RIGHT_ATTACK, GUARDIAN_LEFT_ATTACK, GUARDIAN_MASS_DESTRUCTION, GUARDIAN_RAGE_STOMP, GUARDIAN_RAGE_UPPERCUT, GUARDIAN_FALLEN};
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new CmAttackGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new PunchAttackGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new BurstAttackGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new StompAttackGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new UppercutAndBulletGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new RageUppercut());
        this.field_70714_bg.func_75776_a(1, (Goal)new MassDestruction());
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 50.0).func_233815_a_(Attributes.field_233821_d_, (double)0.27f).func_233815_a_(Attributes.field_233823_f_, CMConfig.EnderguardianDamage).func_233815_a_(Attributes.field_233818_a_, CMConfig.EnderguardianHealth).func_233815_a_(Attributes.field_233826_i_, 20.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_HELMETLESS, (Object)false);
        this.func_184212_Q().func_187214_a(IS_AWAKEN, (Object)true);
        this.func_184212_Q().func_187214_a(USED_MASS_DESTRUCTION, (Object)false);
    }

    private static Animation getRandomAttack(Random rand) {
        switch (rand.nextInt(4)) {
            case 0: {
                return GUARDIAN_RIGHT_STRONG_ATTACK;
            }
            case 1: {
                return GUARDIAN_LEFT_STRONG_ATTACK;
            }
            case 2: {
                return GUARDIAN_RIGHT_ATTACK;
            }
            case 3: {
                return GUARDIAN_LEFT_ATTACK;
            }
        }
        return GUARDIAN_RIGHT_STRONG_ATTACK;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("is_Helmetless", this.getIsHelmetless());
        compound.func_74757_a("is_Awaken", this.getIsAwaken());
        compound.func_74757_a("used_mass_destruction", this.getUsedMassDestruction());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setIsHelmetless(compound.func_74767_n("is_Helmetless"));
        this.setIsAwaken(compound.func_74767_n("is_Awaken"));
        this.setUsedMassDestruction(compound.func_74767_n("used_mass_destruction"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void setIsHelmetless(boolean isHelmetless) {
        this.func_184212_Q().func_187227_b(IS_HELMETLESS, (Object)isHelmetless);
    }

    public boolean getIsHelmetless() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_HELMETLESS);
    }

    public void setUsedMassDestruction(boolean usedMassDestruction) {
        this.func_184212_Q().func_187227_b(USED_MASS_DESTRUCTION, (Object)usedMassDestruction);
    }

    public boolean getUsedMassDestruction() {
        return (Boolean)this.func_184212_Q().func_187225_a(USED_MASS_DESTRUCTION);
    }

    public void setIsAwaken(boolean isAwaken) {
        this.func_184212_Q().func_187227_b(IS_AWAKEN, (Object)isAwaken);
    }

    public boolean getIsAwaken() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_AWAKEN);
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected int func_70682_h(int air) {
        return air;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        double range;
        if (this.getAnimation() == GUARDIAN_MASS_DESTRUCTION && !source.func_76357_e()) {
            return false;
        }
        if (!source.func_76357_e()) {
            damage = Math.min((float)CMConfig.EnderguardianDamageCap, damage);
        }
        if ((range = this.calculateRange(source)) > CMConfig.EnderguardianLongRangelimit * CMConfig.EnderguardianLongRangelimit) {
            return false;
        }
        if (!this.getIsAwaken()) {
            this.setIsAwaken(true);
        }
        Entity entity = source.func_76364_f();
        if (!this.getIsHelmetless() && entity instanceof AbstractArrowEntity) {
            return false;
        }
        if (entity instanceof ShulkerBulletEntity || entity instanceof Ender_Guardian_Bullet_Entity) {
            return false;
        }
        if (entity instanceof GolemEntity) {
            damage = (float)((double)damage * 0.5);
        }
        return super.func_70097_a(source, damage);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70177_z = this.field_70761_aq;
        if (!this.func_174814_R() && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)67);
        }
        this.repelEntities(1.8f, 4.0f, 1.8f, 1.8f);
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        this.prevdeactivateProgress = this.deactivateProgress;
        if (!this.getIsAwaken() && this.deactivateProgress < 40.0f) {
            this.deactivateProgress = 40.0f;
        }
        LivingEntity target = this.func_70638_az();
        Animation animation = Ender_Guardian_Entity.getRandomAttack(this.field_70146_Z);
        if (this.func_70089_S()) {
            if (!this.getIsHelmetless() && this.isHelmetless()) {
                this.setIsHelmetless(true);
                this.BrokenHelmet();
            }
            if (!this.func_175446_cd() && this.getAnimation() == NO_ANIMATION && !this.getUsedMassDestruction() && this.isHelmetless()) {
                this.setAnimation(GUARDIAN_MASS_DESTRUCTION);
            } else if (target != null && target.func_70089_S()) {
                if (!this.func_175446_cd() && this.getAnimation() == NO_ANIMATION && this.func_70032_d((Entity)target) < 2.75f) {
                    if (this.field_70146_Z.nextInt(2) == 0) {
                        this.setAnimation(GUARDIAN_BURST_ATTACK);
                    } else {
                        this.setAnimation(animation);
                    }
                } else if (!this.func_175446_cd() && this.getAnimation() == NO_ANIMATION && this.func_70032_d((Entity)target) > 2.75f && this.func_70032_d((Entity)target) < 4.3f && target.func_70644_a(Effects.field_188424_y)) {
                    if (this.field_70146_Z.nextInt(3) == 0) {
                        if (this.getIsHelmetless()) {
                            this.setAnimation(GUARDIAN_RAGE_UPPERCUT);
                        } else {
                            this.setAnimation(GUARDIAN_UPPERCUT_AND_BULLET);
                        }
                    } else {
                        this.setAnimation(GUARDIAN_BURST_ATTACK);
                    }
                } else if (this.stomp_cooldown <= 0 && !this.func_175446_cd() && this.getAnimation() == NO_ANIMATION && target.func_233570_aj_() && (this.func_70032_d((Entity)target) > 6.0f && this.func_70032_d((Entity)target) < 13.0f || this.func_70032_d((Entity)target) > 2.75f && this.func_70032_d((Entity)target) < 4.3f && this.field_70146_Z.nextInt(12) == 0)) {
                    this.stomp_cooldown = 400;
                    if (this.getIsHelmetless()) {
                        this.setAnimation(GUARDIAN_RAGE_STOMP);
                    } else {
                        this.setAnimation(GUARDIAN_STOMP);
                    }
                } else if (!this.func_175446_cd() && this.getAnimation() == NO_ANIMATION && this.func_70032_d((Entity)target) > 2.75f && this.func_70032_d((Entity)target) < 4.3f) {
                    if (this.field_70146_Z.nextInt(4) == 0) {
                        if (this.getIsHelmetless()) {
                            this.setAnimation(GUARDIAN_RAGE_UPPERCUT);
                        } else {
                            this.setAnimation(GUARDIAN_UPPERCUT_AND_BULLET);
                        }
                    } else {
                        this.setAnimation(animation);
                    }
                }
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.getIsHelmetless()) {
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(10.0);
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.29f);
        }
        if (this.getAnimation() == GUARDIAN_LEFT_STRONG_ATTACK) {
            if (this.getAnimationTick() < 2) {
                this.GravityPullparticle();
            }
            if (this.getAnimationTick() < 29) {
                this.GravityPull();
            }
            if (this.getAnimationTick() == 34) {
                this.func_184185_a((SoundEvent)ModSounds.ENDER_GUARDIAN_FIST.get(), 0.5f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
                this.AreaAttack(5.15f, 5.0f, 70.0f, 1.1f, 100);
                this.Attackparticle(2.2f, 0.0f);
                ScreenShake_Entity.ScreenShake(this.field_70170_p, this.func_213303_ch(), 20.0f, 0.2f, 0, 10);
            }
        }
        if (this.getAnimation() == GUARDIAN_RIGHT_STRONG_ATTACK) {
            if (this.getAnimationTick() < 2) {
                this.GravityPullparticle();
            }
            if (this.getAnimationTick() < 24) {
                this.GravityPull();
            }
            if (this.getAnimationTick() == 29) {
                this.AreaAttack(5.15f, 5.0f, 70.0f, 1.1f, 100);
                this.func_184185_a((SoundEvent)ModSounds.ENDER_GUARDIAN_FIST.get(), 0.5f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
                this.Attackparticle(2.2f, 0.0f);
                ScreenShake_Entity.ScreenShake(this.field_70170_p, this.func_213303_ch(), 20.0f, 0.2f, 0, 10);
            }
        }
        if (this.getAnimation() == GUARDIAN_RIGHT_ATTACK && this.getAnimationTick() == 22) {
            this.AreaAttack(5.85f, 5.0f, 80.0f, 1.0f, 80);
            this.func_184185_a((SoundEvent)ModSounds.ENDER_GUARDIAN_FIST.get(), 0.5f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
            this.Attackparticle(2.75f, 0.5f);
            ScreenShake_Entity.ScreenShake(this.field_70170_p, this.func_213303_ch(), 15.0f, 0.1f, 0, 10);
        }
        if (this.getAnimation() == GUARDIAN_LEFT_ATTACK && this.getAnimationTick() == 19) {
            this.AreaAttack(5.85f, 5.0f, 80.0f, 1.0f, 80);
            this.func_184185_a((SoundEvent)ModSounds.ENDER_GUARDIAN_FIST.get(), 0.5f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
            this.Attackparticle(2.75f, -0.5f);
            ScreenShake_Entity.ScreenShake(this.field_70170_p, this.func_213303_ch(), 15.0f, 0.1f, 0, 10);
        }
        if (this.getAnimation() == GUARDIAN_BURST_ATTACK) {
            if (this.getAnimationTick() == 15) {
                this.Burstparticle();
            }
            if (this.getAnimationTick() == 27) {
                this.func_184185_a(SoundEvents.field_187539_bB, 1.5f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
                this.AreaAttack(7.5f, 6.0f, 100.0f, 1.0f, 0);
            }
        }
        if ((this.getAnimation() == GUARDIAN_UPPERCUT_AND_BULLET || this.getAnimation() == GUARDIAN_RAGE_UPPERCUT) && this.getAnimationTick() == 27) {
            this.func_184185_a(SoundEvents.field_187539_bB, 1.5f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
            this.AreaAttack(6.25f, 6.0f, 60.0f, 1.5f, 150);
            ScreenShake_Entity.ScreenShake(this.field_70170_p, this.func_213303_ch(), 15.0f, 0.3f, 0, 10);
        }
        if (this.getAnimation() == GUARDIAN_STOMP && this.getAnimationTick() == 32) {
            this.StompAttack();
            this.Attackparticle(0.4f, 0.8f);
            ScreenShake_Entity.ScreenShake(this.field_70170_p, this.func_213303_ch(), 10.0f, 0.1f, 0, 5);
        }
        if (this.getAnimation() == GUARDIAN_RAGE_STOMP && (this.getAnimationTick() == 32 || this.getAnimationTick() == 53 || this.getAnimationTick() == 62)) {
            this.StompAttack();
            this.Attackparticle(0.4f, 0.8f);
            ScreenShake_Entity.ScreenShake(this.field_70170_p, this.func_213303_ch(), 10.0f, 0.1f, 0, 5);
        }
        if (this.getAnimation() == GUARDIAN_RAGE_UPPERCUT && this.getAnimationTick() == 84) {
            this.RageAttack();
            this.AreaAttack(5.5f, 5.0f, 120.0f, 1.2f, 100);
            this.func_184185_a(SoundEvents.field_187539_bB, 1.5f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
            ScreenShake_Entity.ScreenShake(this.field_70170_p, this.func_213303_ch(), 15.0f, 0.2f, 0, 10);
        }
        if (this.getAnimation() == GUARDIAN_MASS_DESTRUCTION) {
            this.setUsedMassDestruction(true);
            if (this.getAnimationTick() == 39) {
                this.Attackparticle(2.75f, 2.25f);
                this.Attackparticle(2.75f, -2.25f);
                this.MassDestruction(5.0f, 1.1f, 150);
                ScreenShake_Entity.ScreenShake(this.field_70170_p, this.func_213303_ch(), 15.0f, 0.3f, 0, 10);
                if (this.Breaking) {
                    this.BlockBreaking(15, 2, 15);
                } else if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                    this.BlockBreaking(15, 2, 15);
                }
            }
        }
        if (this.stomp_cooldown > 0) {
            --this.stomp_cooldown;
        }
    }

    public boolean isHelmetless() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    public void setMaxHealth(double maxHealth, boolean heal) {
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(maxHealth);
        if (heal) {
            this.func_70691_i((float)maxHealth);
        }
    }

    @Override
    protected void onDeathAIUpdate() {
        super.onDeathAIUpdate();
        this.func_213293_j(0.0, this.func_213322_ci().field_72448_b, 0.0);
        if (this.field_70725_aQ == 50) {
            this.func_184185_a((SoundEvent)ModSounds.MONSTROSITYLAND.get(), 1.0f, 1.0f);
        }
        if (this.field_70725_aQ == 100) {
            this.func_184185_a(SoundEvents.field_187791_eX, 1.0f, 1.0f);
        }
    }

    @Override
    @Nullable
    public Animation getDeathAnimation() {
        return GUARDIAN_FALLEN;
    }

    private void AreaAttack(float range, float height, float arc, float damage, int ticks) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.func_226281_cx_() - this.func_226281_cx_(), entityHit.func_226277_ct_() - this.func_226277_ct_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.field_70761_aq % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.func_226281_cx_() - this.func_226281_cx_()) * (entityHit.func_226281_cx_() - this.func_226281_cx_()) + (entityHit.func_226277_ct_() - this.func_226277_ct_()) * (entityHit.func_226277_ct_() - this.func_226277_ct_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || entityHit instanceof Ender_Guardian_Entity) continue;
            entityHit.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_) * damage);
            if (entityHit instanceof PlayerEntity && entityHit.func_184585_cz() && ticks > 0) {
                Ender_Guardian_Entity.disableShield(entityHit, ticks);
            }
            if (this.getAnimation() == GUARDIAN_UPPERCUT_AND_BULLET || this.getAnimation() == GUARDIAN_RAGE_UPPERCUT) {
                entityHit.func_213317_d(entityHit.func_213322_ci().func_72441_c(0.0, 0.5, 0.0));
            }
            if (this.getAnimation() != GUARDIAN_BURST_ATTACK) continue;
            this.launch((Entity)entityHit);
        }
    }

    private void MassDestruction(float grow, float damage, int ticks) {
        this.func_184185_a(SoundEvents.field_187539_bB, 1.5f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
        for (LivingEntity entityHit : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_186662_g((double)grow))) {
            if (this.func_184191_r((Entity)entityHit) || entityHit instanceof Ender_Guardian_Entity || entityHit == this) continue;
            entityHit.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_) * damage);
            if (entityHit instanceof PlayerEntity && entityHit.func_184585_cz()) {
                Ender_Guardian_Entity.disableShield(entityHit, ticks);
            }
            this.launch((Entity)entityHit);
        }
    }

    private void BlockBreaking(int x, int y, int z) {
        int MthX = MathHelper.func_76128_c((double)this.func_226277_ct_());
        int MthY = MathHelper.func_76128_c((double)this.func_226278_cu_());
        int MthZ = MathHelper.func_76128_c((double)this.func_226281_cx_());
        boolean flag = false;
        if (!this.field_70170_p.field_72995_K) {
            for (int k2 = -x; k2 <= x; ++k2) {
                for (int l2 = -z; l2 <= z; ++l2) {
                    for (int j = -y; j <= -1; ++j) {
                        int i3 = MthX + k2;
                        int k = MthY + j;
                        int l = MthZ + l2;
                        BlockPos blockpos = new BlockPos(i3, k, l);
                        BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                        Block block = blockstate.func_177230_c();
                        ITag Tag = BlockTags.func_199896_a().func_199910_a(ModTag.ENDER_GUARDIAN_CAN_DESTROY);
                        if (block == Blocks.field_150350_a || !Tag.func_230235_a_((Object)block) || !blockstate.canEntityDestroy((IBlockReader)this.field_70170_p, blockpos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate)) continue;
                        flag = this.field_70170_p.func_225521_a_(blockpos, false, (Entity)this) || flag;
                    }
                }
            }
        }
    }

    private void Burstparticle() {
        if (this.field_70170_p.field_72995_K) {
            double d0 = this.func_226277_ct_();
            double d1 = this.func_226278_cu_() + 2.0;
            double d2 = this.func_226281_cx_();
            int size = 5;
            for (int i = -size; i <= size; ++i) {
                for (int j = -size; j <= size; ++j) {
                    for (int k = -size; k <= size; ++k) {
                        double d3 = (double)j + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.5;
                        double d4 = (double)i + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.5;
                        double d5 = (double)k + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.5;
                        double d6 = (double)MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5)) / 0.5 + this.field_70146_Z.nextGaussian() * 0.05;
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_239819_as_, d0, d1, d2, d3 / d6, d4 / d6, d5 / d6);
                        if (i == -size || i == size || j == -size || j == size) continue;
                        k += size * 2 - 1;
                    }
                }
            }
        }
    }

    private void launch(Entity entityHit) {
        double d0 = entityHit.func_226277_ct_() - this.func_226277_ct_();
        double d1 = entityHit.func_226281_cx_() - this.func_226281_cx_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        entityHit.func_70024_g(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
    }

    private void GravityPull() {
        List<LivingEntity> entities = this.getEntityLivingBaseNearby(12.0, 12.0, 12.0, 12.0);
        for (LivingEntity inRange : entities) {
            if (inRange instanceof PlayerEntity && ((PlayerEntity)inRange).field_71075_bZ.field_75102_a || this.func_184191_r((Entity)inRange)) continue;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = MathHelper.func_76134_b((float)angle);
            double theta = (double)this.field_70761_aq * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            Vector3d diff = inRange.func_213303_ch().func_178788_d(this.func_213303_ch().func_72441_c(2.0 * vecX + extraX * 0.25, 0.0, 2.0 * vecZ + extraZ * 0.25));
            diff = diff.func_72432_b().func_186678_a(0.085);
            inRange.func_213317_d(inRange.func_213322_ci().func_178788_d(diff));
        }
    }

    private void GravityPullparticle() {
        if (this.field_70170_p.field_72995_K) {
            for (int i1 = 0; i1 < 80 + this.field_70146_Z.nextInt(12); ++i1) {
                float angle = (float)Math.PI / 180 * this.field_70761_aq + (float)i1;
                double extraX = MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = MathHelper.func_76134_b((float)angle);
                double theta = (double)this.field_70761_aq * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.5707963267948966);
                double vecZ = Math.sin(theta);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226277_ct_() + 2.2 * vecX + extraX * 0.75, this.func_226278_cu_() + extraY, this.func_226281_cx_() + 2.2 * vecZ + extraZ * 0.75, (this.field_70146_Z.nextDouble() - 0.5) * 12.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 12.0);
            }
        }
    }

    private void Attackparticle(float vec, float math) {
        if (this.field_70170_p.field_72995_K) {
            for (int i1 = 0; i1 < 80 + this.field_70146_Z.nextInt(12); ++i1) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                float angle = (float)Math.PI / 180 * this.field_70761_aq + (float)i1;
                float f = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                double extraX = 1.2 * (double)MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = MathHelper.func_76134_b((float)angle);
                double theta = (double)this.field_70761_aq * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.5707963267948966);
                double vecZ = Math.sin(theta);
                int hitX = MathHelper.func_76128_c((double)(this.func_226277_ct_() + (double)vec * vecX + extraX));
                int hitY = MathHelper.func_76128_c((double)this.func_226278_cu_());
                int hitZ = MathHelper.func_76128_c((double)(this.func_226281_cx_() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = this.field_70170_p.func_180495_p(hit.func_177977_b());
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, block), this.func_226277_ct_() + (double)vec * vecX + extraX + (double)(f * math), this.func_226278_cu_() + extraY, this.func_226281_cx_() + (double)vec * vecZ + extraZ + (double)(f1 * math), motionX, motionY, motionZ);
            }
        }
    }

    private void StompAttack() {
        this.func_184185_a((SoundEvent)ModSounds.ENDER_GUARDIAN_FIST.get(), 0.3f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
        LivingEntity target = this.func_70638_az();
        if (target != null) {
            int k;
            double d0 = Math.min(target.func_226278_cu_(), this.func_226278_cu_());
            double d1 = Math.max(target.func_226278_cu_(), this.func_226278_cu_()) + 1.0;
            Vector3d looking = this.func_70040_Z();
            Vector3d[] all = new Vector3d[]{looking, looking.func_178785_b(0.4f), looking.func_178785_b(-0.4f)};
            Vector3d[] all2 = new Vector3d[]{looking.func_178785_b(0.1f), looking.func_178785_b(-0.1f)};
            float f = (float)MathHelper.func_181159_b((double)(target.func_226281_cx_() - this.func_226281_cx_()), (double)(target.func_226277_ct_() - this.func_226277_ct_()));
            for (k = 0; k < 6; ++k) {
                float f2 = f + (float)k * (float)Math.PI * 2.0f / 6.0f + 1.2566371f;
                this.spawnFangs(this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f2) * 2.5, this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f2) * 2.5, d0, d1, f2, 3);
            }
            for (k = 0; k < 11; ++k) {
                float f3 = f + (float)k * (float)Math.PI * 2.0f / 11.0f + 0.62831855f;
                this.spawnFangs(this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f3) * 3.5, this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f3) * 3.5, d0, d1, f3, 10);
            }
            for (k = 0; k < 14; ++k) {
                float f4 = f + (float)k * (float)Math.PI * 2.0f / 14.0f + 0.31415927f;
                this.spawnFangs(this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f4) * 4.5, this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f4) * 4.5, d0, d1, f4, 15);
            }
            switch (this.field_70146_Z.nextInt(3)) {
                case 0: {
                    for (Vector3d vector3d : all) {
                        float f0 = (float)MathHelper.func_181159_b((double)vector3d.field_72449_c, (double)vector3d.field_72450_a);
                        for (int l = 0; l < 13; ++l) {
                            double d2 = 1.25 * (double)(l + 1);
                            int j = (int)(0.75f * (float)l);
                            this.spawnFangs(this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f0) * d2, this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f0) * d2, d0, d1, f0, j);
                        }
                    }
                    break;
                }
                case 1: {
                    for (Vector3d vector3d : all2) {
                        float f0 = (float)MathHelper.func_181159_b((double)vector3d.field_72449_c, (double)vector3d.field_72450_a);
                        for (int l = 0; l < 13; ++l) {
                            double d2 = 1.25 * (double)(l + 1);
                            int j = (int)(0.25f * (float)l);
                            this.spawnFangs(this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f0) * d2, this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f0) * d2, d0, d1, f0, j);
                        }
                    }
                    break;
                }
                case 2: {
                    for (int l = 0; l < 13; ++l) {
                        double d2 = 1.25 * (double)(l + 1);
                        int j = (int)(0.5f * (float)l);
                        this.spawnFangs(this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * d2, this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1, f, j);
                    }
                    break;
                }
            }
        }
    }

    private void RageAttack() {
        LivingEntity target = this.func_70638_az();
        if (target != null) {
            Vector3d[] all;
            double d0 = Math.min(target.func_226278_cu_(), this.func_226278_cu_());
            double d1 = Math.max(target.func_226278_cu_(), this.func_226278_cu_()) + 1.0;
            Vector3d looking = this.func_70040_Z();
            for (Vector3d vector3d : all = new Vector3d[]{looking, looking.func_178785_b(0.3f), looking.func_178785_b(-0.3f), looking.func_178785_b(0.6f), looking.func_178785_b(-0.6f), looking.func_178785_b(0.9f), looking.func_178785_b(-0.9f)}) {
                float f0 = (float)MathHelper.func_181159_b((double)vector3d.field_72449_c, (double)vector3d.field_72450_a);
                for (int l = 0; l < 10; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    int j = (int)(0.75f * (float)l);
                    this.spawnFangs(this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f0) * d2, this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f0) * d2, d0, d1, f0, j);
                }
            }
        }
    }

    private void spawnFangs(double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos blockpos = new BlockPos(x, maxY, z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_224755_d((IBlockReader)this.field_70170_p, blockpos1, Direction.UP)) continue;
            if (!this.field_70170_p.func_175623_d(blockpos) && !(voxelshape = (blockstate1 = this.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b()) {
                d0 = voxelshape.func_197758_c(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)minY) - 1);
        if (flag) {
            this.field_70170_p.func_217376_c((Entity)new Void_Rune_Entity(this.field_70170_p, x, (double)blockpos.func_177956_o() + d0, z, rotation, delay, (LivingEntity)this));
        }
    }

    private void BrokenHelmet() {
        double xx = MathHelper.func_76134_b((float)(this.field_70177_z % 360.0f / 180.0f * (float)Math.PI)) * 0.75f;
        double zz = MathHelper.func_76126_a((float)(this.field_70177_z % 360.0f / 180.0f * (float)Math.PI)) * 0.75f;
        this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_() + xx, this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_() + zz, 2.0f, Explosion.Mode.NONE);
    }

    private void Bulletpattern() {
        LivingEntity target = this.func_70638_az();
        if (target != null) {
            BlockPos tgt = target.func_233580_cy_();
            double tx = tgt.func_177958_n();
            double tz = tgt.func_177952_p();
            double ty = target.func_226278_cu_() + 0.1;
            if (this.getAnimationTick() == 54) {
                if (!(target.func_233570_aj_() || target.func_70090_H() || this.field_70170_p.func_180495_p(tgt.func_177977_b()).func_185904_a().func_76230_c())) {
                    ty -= 1.0;
                }
                BlockPos Pos = this.func_233580_cy_();
                double sx = Pos.func_177958_n();
                double sz = Pos.func_177952_p();
                Direction dir = Direction.func_210769_a((double)(tx - sx), (double)0.0, (double)(tz - sz));
                double cx = dir.func_82601_c();
                double cz = dir.func_82599_e();
                double offsetangle = Math.toRadians(6.0);
                for (int i = -4; i <= 4; ++i) {
                    double angle = (double)(i - 2) * offsetangle;
                    double x = cx * Math.cos(angle) + cz * Math.sin(angle);
                    double z = -cx * Math.sin(angle) + cz * Math.cos(angle);
                    Ender_Guardian_Bullet_Entity bullet = new Ender_Guardian_Bullet_Entity(this.field_70170_p, (LivingEntity)this, x, this.func_226278_cu_() + 2.0, z);
                    bullet.func_212361_a((Entity)this);
                    bullet.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() - 2.0 + this.field_70146_Z.nextDouble() * 4.0, this.func_226281_cx_());
                    bullet.setUp(30, cx, 0.0, cz, tx - 7.0 * cx + (double)i * cz, ty, tz - 7.0 * cz + (double)i * cx);
                    this.field_70170_p.func_217376_c((Entity)bullet);
                }
            }
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    public ItemEntity func_199701_a_(ItemStack stack) {
        ItemEntity itementity = this.func_70099_a(stack, 0.0f);
        if (itementity != null) {
            itementity.func_213317_d(itementity.func_213322_ci().func_216372_d(0.0, 3.5, 0.0));
            itementity.func_184195_f(true);
            itementity.func_174873_u();
        }
        return itementity;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn == this) {
            return true;
        }
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof Ender_Guardian_Entity || entityIn instanceof Ender_Golem_Entity || entityIn instanceof ShulkerEntity || entityIn instanceof Endermaptera_Entity) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    @Override
    protected void repelEntities(float x, float y, float z, float radius) {
        super.repelEntities(x, y, z, radius);
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingData, @Nullable CompoundNBT compound) {
        this.setIsHelmetless(false);
        this.setUsedMassDestruction(false);
        this.setMaxHealth(CMConfig.EnderguardianHealth, true);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(CMConfig.EnderguardianDamage);
        return super.func_213386_a(world, difficulty, reason, livingData, compound);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.func_184185_a((SoundEvent)ModSounds.ENDERGUARDIANHURT.get(), 1.0f, 1.0f);
        if (this.getIsHelmetless()) {
            this.func_184185_a(SoundEvents.field_187783_eT, 1.0f, 0.8f);
        }
        return null;
    }

    protected SoundEvent func_184639_G() {
        return this.getIsHelmetless() ? SoundEvents.field_187773_eO : null;
    }

    protected SoundEvent func_184615_bR() {
        this.func_184185_a((SoundEvent)ModSounds.ENDERGUARDIANDEATH.get(), 1.0f, 1.0f);
        if (this.getIsHelmetless()) {
            this.func_184185_a(SoundEvents.field_187781_eS, 2.0f, 0.8f);
        }
        return null;
    }

    protected BodyController func_184650_s() {
        return new SmartBodyHelper2((MobEntity)this);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new GroundPathNavigatorWide((MobEntity)this, this.field_70170_p);
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 67) {
            cataclysm.PROXY.onEntityStatus((Entity)this, id);
        } else {
            super.func_70103_a(id);
        }
    }

    class MassDestruction
    extends Goal {
        public MassDestruction() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return Ender_Guardian_Entity.this.getAnimation() == GUARDIAN_MASS_DESTRUCTION;
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public void func_75246_d() {
            Ender_Guardian_Entity.this.func_213293_j(0.0, Ender_Guardian_Entity.this.func_213322_ci().field_72448_b, 0.0);
            LivingEntity target = Ender_Guardian_Entity.this.func_70638_az();
            if (Ender_Guardian_Entity.this.getAnimationTick() < 39 && target != null || Ender_Guardian_Entity.this.getAnimationTick() > 50 && target != null) {
                Ender_Guardian_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            } else {
                Ender_Guardian_Entity.this.field_70177_z = Ender_Guardian_Entity.this.field_70126_B;
                Ender_Guardian_Entity.this.field_70761_aq = Ender_Guardian_Entity.this.field_70760_ar;
            }
        }
    }

    class RageUppercut
    extends Goal {
        public RageUppercut() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return Ender_Guardian_Entity.this.getAnimation() == GUARDIAN_RAGE_UPPERCUT;
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public void func_75246_d() {
            LivingEntity target = Ender_Guardian_Entity.this.func_70638_az();
            if (Ender_Guardian_Entity.this.getAnimationTick() < 29 && target != null || Ender_Guardian_Entity.this.getAnimationTick() > 54 && Ender_Guardian_Entity.this.getAnimationTick() < 84 && target != null || Ender_Guardian_Entity.this.getAnimationTick() > 104 && target != null) {
                Ender_Guardian_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            } else {
                Ender_Guardian_Entity.this.field_70177_z = Ender_Guardian_Entity.this.field_70126_B;
                Ender_Guardian_Entity.this.field_70761_aq = Ender_Guardian_Entity.this.field_70760_ar;
            }
            if (Ender_Guardian_Entity.this.getAnimationTick() == 26) {
                float f1 = (float)Math.cos(Math.toRadians(Ender_Guardian_Entity.this.field_70177_z + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(Ender_Guardian_Entity.this.field_70177_z + 90.0f));
                Ender_Guardian_Entity.this.func_70024_g((double)f1 * 1.5, 0.0, (double)f2 * 1.5);
            }
            if (Ender_Guardian_Entity.this.getAnimationTick() > 32 || Ender_Guardian_Entity.this.getAnimationTick() < 26) {
                Ender_Guardian_Entity.this.func_213293_j(0.0, Ender_Guardian_Entity.this.func_213322_ci().field_72448_b, 0.0);
            }
            Ender_Guardian_Entity.this.Bulletpattern();
        }
    }

    class UppercutAndBulletGoal
    extends Goal {
        public UppercutAndBulletGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return Ender_Guardian_Entity.this.getAnimation() == GUARDIAN_UPPERCUT_AND_BULLET;
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public void func_75246_d() {
            LivingEntity target = Ender_Guardian_Entity.this.func_70638_az();
            if (Ender_Guardian_Entity.this.getAnimationTick() < 29 && target != null || Ender_Guardian_Entity.this.getAnimationTick() > 54 && target != null) {
                Ender_Guardian_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            } else {
                Ender_Guardian_Entity.this.field_70177_z = Ender_Guardian_Entity.this.field_70126_B;
                Ender_Guardian_Entity.this.field_70761_aq = Ender_Guardian_Entity.this.field_70760_ar;
            }
            if (Ender_Guardian_Entity.this.getAnimationTick() == 26) {
                float f1 = (float)Math.cos(Math.toRadians(Ender_Guardian_Entity.this.field_70177_z + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(Ender_Guardian_Entity.this.field_70177_z + 90.0f));
                Ender_Guardian_Entity.this.func_70024_g((double)f1 * 1.5, 0.0, (double)f2 * 1.5);
            }
            if (Ender_Guardian_Entity.this.getAnimationTick() > 32 || Ender_Guardian_Entity.this.getAnimationTick() < 26) {
                Ender_Guardian_Entity.this.func_213293_j(0.0, Ender_Guardian_Entity.this.func_213322_ci().field_72448_b, 0.0);
            }
            Ender_Guardian_Entity.this.Bulletpattern();
        }
    }

    class BurstAttackGoal
    extends Goal {
        public BurstAttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return Ender_Guardian_Entity.this.getAnimation() == GUARDIAN_BURST_ATTACK;
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public void func_75246_d() {
            Ender_Guardian_Entity.this.func_213293_j(0.0, Ender_Guardian_Entity.this.func_213322_ci().field_72448_b, 0.0);
            LivingEntity target = Ender_Guardian_Entity.this.func_70638_az();
            if (Ender_Guardian_Entity.this.getAnimation() == GUARDIAN_BURST_ATTACK) {
                if (Ender_Guardian_Entity.this.getAnimationTick() < 27 && target != null || Ender_Guardian_Entity.this.getAnimationTick() > 47 && target != null) {
                    Ender_Guardian_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                } else {
                    Ender_Guardian_Entity.this.field_70177_z = Ender_Guardian_Entity.this.field_70126_B;
                    Ender_Guardian_Entity.this.field_70761_aq = Ender_Guardian_Entity.this.field_70760_ar;
                }
            }
        }
    }

    class StompAttackGoal
    extends Goal {
        public StompAttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return Ender_Guardian_Entity.this.getAnimation() == GUARDIAN_STOMP || Ender_Guardian_Entity.this.getAnimation() == GUARDIAN_RAGE_STOMP;
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public void func_75246_d() {
            Ender_Guardian_Entity.this.func_213293_j(0.0, Ender_Guardian_Entity.this.func_213322_ci().field_72448_b, 0.0);
            LivingEntity target = Ender_Guardian_Entity.this.func_70638_az();
            if (Ender_Guardian_Entity.this.getAnimation() == GUARDIAN_STOMP) {
                if (Ender_Guardian_Entity.this.getAnimationTick() < 32 && target != null || Ender_Guardian_Entity.this.getAnimationTick() > 42 && target != null) {
                    Ender_Guardian_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                } else {
                    Ender_Guardian_Entity.this.field_70177_z = Ender_Guardian_Entity.this.field_70126_B;
                    Ender_Guardian_Entity.this.field_70761_aq = Ender_Guardian_Entity.this.field_70760_ar;
                }
            }
            if (Ender_Guardian_Entity.this.getAnimation() == GUARDIAN_RAGE_STOMP) {
                if (Ender_Guardian_Entity.this.getAnimationTick() < 32 && target != null || Ender_Guardian_Entity.this.getAnimationTick() > 42 && Ender_Guardian_Entity.this.getAnimationTick() < 53 && target != null || Ender_Guardian_Entity.this.getAnimationTick() > 58 && target != null) {
                    Ender_Guardian_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                } else {
                    Ender_Guardian_Entity.this.field_70177_z = Ender_Guardian_Entity.this.field_70126_B;
                    Ender_Guardian_Entity.this.field_70761_aq = Ender_Guardian_Entity.this.field_70760_ar;
                }
            }
        }
    }

    class PunchAttackGoal
    extends Goal {
        public PunchAttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return Ender_Guardian_Entity.this.getAnimation() == GUARDIAN_LEFT_ATTACK || Ender_Guardian_Entity.this.getAnimation() == GUARDIAN_RIGHT_ATTACK || Ender_Guardian_Entity.this.getAnimation() == GUARDIAN_LEFT_STRONG_ATTACK || Ender_Guardian_Entity.this.getAnimation() == GUARDIAN_RIGHT_STRONG_ATTACK;
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public void func_75246_d() {
            Ender_Guardian_Entity.this.func_213293_j(0.0, Ender_Guardian_Entity.this.func_213322_ci().field_72448_b, 0.0);
            LivingEntity target = Ender_Guardian_Entity.this.func_70638_az();
            if (Ender_Guardian_Entity.this.getAnimation() == GUARDIAN_LEFT_ATTACK) {
                if (Ender_Guardian_Entity.this.getAnimationTick() < 17 && target != null || Ender_Guardian_Entity.this.getAnimationTick() > 27 && target != null) {
                    Ender_Guardian_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                } else {
                    Ender_Guardian_Entity.this.field_70177_z = Ender_Guardian_Entity.this.field_70126_B;
                }
            }
            if (Ender_Guardian_Entity.this.getAnimation() == GUARDIAN_RIGHT_ATTACK) {
                if (Ender_Guardian_Entity.this.getAnimationTick() < 22 && target != null || Ender_Guardian_Entity.this.getAnimationTick() > 32 && target != null) {
                    Ender_Guardian_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                } else {
                    Ender_Guardian_Entity.this.field_70177_z = Ender_Guardian_Entity.this.field_70126_B;
                }
            }
            if (Ender_Guardian_Entity.this.getAnimation() == GUARDIAN_LEFT_STRONG_ATTACK) {
                if (Ender_Guardian_Entity.this.getAnimationTick() < 34 && target != null || Ender_Guardian_Entity.this.getAnimationTick() > 44 && target != null) {
                    Ender_Guardian_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                } else {
                    Ender_Guardian_Entity.this.field_70177_z = Ender_Guardian_Entity.this.field_70126_B;
                }
            }
            if (Ender_Guardian_Entity.this.getAnimation() == GUARDIAN_RIGHT_STRONG_ATTACK) {
                if (Ender_Guardian_Entity.this.getAnimationTick() < 29 && target != null || Ender_Guardian_Entity.this.getAnimationTick() > 39 && target != null) {
                    Ender_Guardian_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                } else {
                    Ender_Guardian_Entity.this.field_70177_z = Ender_Guardian_Entity.this.field_70126_B;
                }
            }
        }
    }
}

