/*
 * Decompiled with CFR 0.152.
 */
package L_Ender.cataclysm.entity;

import L_Ender.cataclysm.config.CMConfig;
import L_Ender.cataclysm.entity.AI.CmAttackGoal;
import L_Ender.cataclysm.entity.Boss_monster;
import L_Ender.cataclysm.entity.etc.CMPathNavigateGround;
import L_Ender.cataclysm.entity.etc.SmartBodyHelper2;
import L_Ender.cataclysm.init.ModEffect;
import L_Ender.cataclysm.init.ModSounds;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;

public class Ignis_Entity
extends Boss_monster {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    public static final Animation SWING_ATTACK = Animation.create((int)95);
    public static final Animation HORIZONTAL_SWING_ATTACK = Animation.create((int)68);
    public static final Animation POKE_ATTACK = Animation.create((int)75);
    public static final Animation PHASE = Animation.create((int)130);
    private static final DataParameter<Boolean> IS_BLOCKING = EntityDataManager.func_187226_a(Ignis_Entity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SHIELD = EntityDataManager.func_187226_a(Ignis_Entity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SOUL = EntityDataManager.func_187226_a(Ignis_Entity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int timeWithoutTarget;
    public float blockingProgress;
    public float prevblockingProgress;

    public Ignis_Entity(EntityType entity, World world) {
        super(entity, world);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, SWING_ATTACK, HORIZONTAL_SWING_ATTACK, POKE_ATTACK, PHASE};
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70714_bg.func_75776_a(2, (Goal)new CmAttackGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new Hornzontal_Swing());
        this.field_70714_bg.func_75776_a(1, (Goal)new Poke());
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        double range = this.calculateRange(source);
        if (range > CMConfig.IgnisLongRangelimit * CMConfig.IgnisLongRangelimit) {
            return false;
        }
        if (!source.func_76357_e()) {
            damage = Math.min((float)CMConfig.IgnisDamageCap, damage);
        }
        Entity entity = source.func_76364_f();
        if (damage > 0.0f && this.canBlockDamageSource(source)) {
            this.func_184590_k(damage);
            if (!source.func_76352_a() && entity instanceof LivingEntity) {
                this.func_190629_c((LivingEntity)entity);
            }
            this.func_184185_a(SoundEvents.field_187603_D, 0.5f, 0.4f + this.func_70681_au().nextFloat() * 0.1f);
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    private boolean canBlockDamageSource(DamageSource damageSourceIn) {
        Vector3d vector3d2;
        AbstractArrowEntity abstractarrowentity;
        Entity entity = damageSourceIn.func_76364_f();
        boolean flag = false;
        if (entity instanceof AbstractArrowEntity && (abstractarrowentity = (AbstractArrowEntity)entity).func_213874_s() > 0) {
            flag = true;
        }
        if (!damageSourceIn.func_76363_c() && !flag && this.getIsShield() && (vector3d2 = damageSourceIn.func_188404_v()) != null) {
            Vector3d vector3d = this.func_70676_i(1.0f);
            Vector3d vector3d1 = vector3d2.func_72444_a(this.func_213303_ch()).func_72432_b();
            vector3d1 = new Vector3d(vector3d1.field_72450_a, 0.0, vector3d1.field_72449_c);
            return vector3d1.func_72430_b(vector3d) < 0.0;
        }
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_BLOCKING, (Object)false);
        this.field_70180_af.func_187214_a(IS_SHIELD, (Object)false);
        this.field_70180_af.func_187214_a(IS_SOUL, (Object)false);
    }

    public void setIsBlocking(boolean isBlocking) {
        this.func_184212_Q().func_187227_b(IS_BLOCKING, (Object)isBlocking);
    }

    public boolean getIsBlocking() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_BLOCKING);
    }

    public void setIsShield(boolean isShield) {
        this.func_184212_Q().func_187227_b(IS_SHIELD, (Object)isShield);
    }

    public boolean getIsShield() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_SHIELD);
    }

    public void setIsSoul(boolean isSoul) {
        this.func_184212_Q().func_187227_b(IS_SOUL, (Object)isSoul);
    }

    public boolean getIsSoul() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_SOUL);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 50.0).func_233815_a_(Attributes.field_233821_d_, (double)0.28f).func_233815_a_(Attributes.field_233823_f_, CMConfig.IgnisDamage).func_233815_a_(Attributes.field_233818_a_, CMConfig.IgnisHealth).func_233815_a_(Attributes.field_233826_i_, 10.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public void func_70071_h_() {
        if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        this.prevblockingProgress = this.blockingProgress;
        if (this.getIsBlocking() && this.blockingProgress < 10.0f) {
            this.blockingProgress += 1.0f;
        }
        if (!this.getIsBlocking() && this.blockingProgress > 0.0f) {
            this.blockingProgress -= 1.0f;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(24) == 0 && !this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_() + 0.5, this.func_226278_cu_() + 0.5, this.func_226281_cx_() + 0.5, SoundEvents.field_187597_B, this.func_184176_by(), 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
        }
        this.repelEntities(1.7f, 4.0f, 1.7f, 1.7f);
        this.field_70177_z = this.field_70761_aq;
        LivingEntity target = this.func_70638_az();
        if (this.func_70089_S() && target != null && target.func_70089_S() && !this.func_175446_cd() && this.getAnimation() == NO_ANIMATION && this.func_70032_d((Entity)target) < 5.0f) {
            this.setAnimation(HORIZONTAL_SWING_ATTACK);
        }
        if (!this.field_70170_p.field_72995_K) {
            ++this.timeWithoutTarget;
            if (target != null) {
                this.timeWithoutTarget = 0;
                if (!this.getIsBlocking()) {
                    this.setIsBlocking(true);
                }
            }
            if (this.timeWithoutTarget > 150 && this.getIsBlocking() && target == null) {
                this.timeWithoutTarget = 0;
                this.setIsBlocking(false);
            }
        }
        super.func_70071_h_();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.getIsBlocking() && this.blockingProgress == 10.0f) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setIsShield(true);
            } else if (this.getAnimation() == HORIZONTAL_SWING_ATTACK) {
                this.setIsShield(this.getAnimationTick() > 31);
            }
        } else {
            this.setIsShield(false);
        }
        if (this.getAnimation() == HORIZONTAL_SWING_ATTACK && this.getAnimationTick() == 31) {
            this.func_184185_a((SoundEvent)ModSounds.STRONGSWING.get(), 1.0f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
            this.AreaAttack(6.0f, 6.0f, 250.0f, 1.1f, 0.1f, 100, 5, 300);
        }
    }

    public void setMaxHealth(double maxHealth, boolean heal) {
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(maxHealth);
        if (heal) {
            this.func_70691_i((float)maxHealth);
        }
    }

    private void AreaAttack(float range, float height, float arc, float damage, float hpdamage, int shieldbreakticks, int firetime, int brandticks) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.func_226281_cx_() - this.func_226281_cx_(), entityHit.func_226277_ct_() - this.func_226277_ct_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.field_70761_aq % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.func_226281_cx_() - this.func_226281_cx_()) * (entityHit.func_226281_cx_() - this.func_226281_cx_()) + (entityHit.func_226277_ct_() - this.func_226277_ct_()) * (entityHit.func_226277_ct_() - this.func_226277_ct_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || entityHit instanceof Ignis_Entity) continue;
            boolean flag = entityHit.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)(this.func_233637_b_(Attributes.field_233823_f_) * (double)damage + (double)(entityHit.func_110138_aP() * hpdamage)));
            if (entityHit instanceof PlayerEntity && entityHit.func_184585_cz() && shieldbreakticks > 0) {
                Ignis_Entity.disableShield(entityHit, shieldbreakticks);
            }
            if (!flag) continue;
            entityHit.func_70015_d(firetime);
            EffectInstance effectinstance1 = entityHit.func_70660_b((Effect)ModEffect.EFFECTBLAZING_BRAND.get());
            int i = 1;
            if (effectinstance1 != null) {
                i += effectinstance1.func_76458_c();
                entityHit.func_184596_c((Effect)ModEffect.EFFECTBLAZING_BRAND.get());
            } else {
                --i;
            }
            i = MathHelper.func_76125_a((int)i, (int)0, (int)4);
            EffectInstance effectinstance = new EffectInstance((Effect)ModEffect.EFFECTBLAZING_BRAND.get(), brandticks, i, false, false, true);
            entityHit.func_195064_c(effectinstance);
            this.func_70691_i(10 * (i + 1));
        }
    }

    @Override
    protected void repelEntities(float x, float y, float z, float radius) {
        super.repelEntities(x, y, z, radius);
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingData, @Nullable CompoundNBT compound) {
        this.setMaxHealth(CMConfig.IgnisHealth, true);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(CMConfig.IgnisDamage);
        return super.func_213386_a(world, difficulty, reason, livingData, compound);
    }

    public void func_213352_e(Vector3d travelVector) {
        this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_) * (this.func_180799_ab() ? 0.2f : 1.0f));
        if (this.func_70613_aW() && this.func_180799_ab()) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(travelVector);
        }
    }

    protected BodyController func_184650_s() {
        return new SmartBodyHelper2((MobEntity)this);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new CMPathNavigateGround((MobEntity)this, this.field_70170_p);
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    class Poke
    extends Goal {
        public Poke() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return Ignis_Entity.this.getAnimation() == POKE_ATTACK;
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public void func_75246_d() {
            LivingEntity target = Ignis_Entity.this.func_70638_az();
            if (Ignis_Entity.this.getAnimationTick() < 39 && target != null || Ignis_Entity.this.getAnimationTick() > 59 && target != null) {
                Ignis_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.field_70177_z = Ignis_Entity.this.field_70126_B;
            }
            if (Ignis_Entity.this.getAnimationTick() == 34) {
                float f1 = (float)Math.cos(Math.toRadians(Ignis_Entity.this.field_70177_z + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(Ignis_Entity.this.field_70177_z + 90.0f));
                Ignis_Entity.this.func_70024_g((double)f1 * 1.5, 0.0, (double)f2 * 1.5);
            }
            if (Ignis_Entity.this.getAnimationTick() > 40 || Ignis_Entity.this.getAnimationTick() < 34) {
                Ignis_Entity.this.func_213293_j(0.0, Ignis_Entity.this.func_213322_ci().field_72448_b, 0.0);
            }
        }
    }

    class Hornzontal_Swing
    extends Goal {
        public Hornzontal_Swing() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return Ignis_Entity.this.getAnimation() == HORIZONTAL_SWING_ATTACK;
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public void func_75246_d() {
            LivingEntity target = Ignis_Entity.this.func_70638_az();
            if (Ignis_Entity.this.getAnimationTick() < 31 && target != null || Ignis_Entity.this.getAnimationTick() > 51 && target != null) {
                Ignis_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.field_70177_z = Ignis_Entity.this.field_70126_B;
            }
            if (Ignis_Entity.this.getAnimationTick() == 26) {
                float f1 = (float)Math.cos(Math.toRadians(Ignis_Entity.this.field_70177_z + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(Ignis_Entity.this.field_70177_z + 90.0f));
                if (target != null) {
                    float r = Ignis_Entity.this.func_70032_d((Entity)target);
                    r = MathHelper.func_76131_a((float)r, (float)0.0f, (float)15.0f);
                    Ignis_Entity.this.func_70024_g((double)f1 * 0.3 * (double)r, 0.0, (double)f2 * 0.3 * (double)r);
                } else {
                    Ignis_Entity.this.func_70024_g(f1, 0.0, f2);
                }
            }
            if (Ignis_Entity.this.getAnimationTick() > 32 || Ignis_Entity.this.getAnimationTick() < 26) {
                Ignis_Entity.this.func_213293_j(0.0, Ignis_Entity.this.func_213322_ci().field_72448_b, 0.0);
            }
        }
    }
}

