/*
 * Decompiled with CFR 0.152.
 */
package L_Ender.cataclysm.entity;

import L_Ender.cataclysm.cataclysm;
import L_Ender.cataclysm.config.CMConfig;
import L_Ender.cataclysm.entity.AI.CmAttackGoal;
import L_Ender.cataclysm.entity.Boss_monster;
import L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import L_Ender.cataclysm.entity.etc.GroundPathNavigatorWide;
import L_Ender.cataclysm.entity.etc.SmartBodyHelper2;
import L_Ender.cataclysm.entity.projectile.Lava_Bomb_Entity;
import L_Ender.cataclysm.init.ModEntities;
import L_Ender.cataclysm.init.ModSounds;
import L_Ender.cataclysm.init.ModTag;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class Netherite_Monstrosity_Entity
extends Boss_monster {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    public int frame;
    public static final Animation MONSTROSITY_EARTHQUAKE = Animation.create((int)75);
    public static final Animation MONSTROSITY_CHARGE = Animation.create((int)82);
    public static final Animation MONSTROSITY_ERUPTIONATTACK = Animation.create((int)55);
    public static final Animation MONSTROSITY_EARTHQUAKE2 = Animation.create((int)65);
    public static final Animation MONSTROSITY_EARTHQUAKE3 = Animation.create((int)70);
    public static final Animation MONSTROSITY_BERSERK = Animation.create((int)80);
    public static final Animation MONSTROSITY_DEATH = Animation.create((int)185);
    private static final DataParameter<Boolean> IS_BERSERK = EntityDataManager.func_187226_a(Netherite_Monstrosity_Entity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_AWAKEN = EntityDataManager.func_187226_a(Netherite_Monstrosity_Entity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int lavabombmagazine = CMConfig.Lavabombmagazine;
    public boolean Blocking = CMConfig.NetheritemonstrosityBodyBloking;
    public float deactivateProgress;
    public float prevdeactivateProgress;

    public Netherite_Monstrosity_Entity(EntityType entity, World world) {
        super(entity, world);
        this.field_70728_aV = 300;
        this.field_70138_W = 1.75f;
        this.dropAfterDeathAnim = true;
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, MONSTROSITY_BERSERK, MONSTROSITY_EARTHQUAKE, MONSTROSITY_CHARGE, MONSTROSITY_EARTHQUAKE2, MONSTROSITY_EARTHQUAKE3, MONSTROSITY_ERUPTIONATTACK, MONSTROSITY_DEATH};
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new BerserkGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new AwakenGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new HealGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new ShootGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new EarthQuakeGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new CmAttackGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 50.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, CMConfig.MonstrosityDamage).func_233815_a_(Attributes.field_233818_a_, CMConfig.MonstrosityHealth).func_233815_a_(Attributes.field_233826_i_, 10.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_BERSERK, (Object)false);
        this.func_184212_Q().func_187214_a(IS_AWAKEN, (Object)false);
    }

    private static Animation getRandomAttack(Random rand) {
        switch (rand.nextInt(3)) {
            case 0: {
                return MONSTROSITY_EARTHQUAKE;
            }
            case 1: {
                return MONSTROSITY_EARTHQUAKE2;
            }
            case 2: {
                return MONSTROSITY_EARTHQUAKE3;
            }
        }
        return MONSTROSITY_EARTHQUAKE;
    }

    public boolean func_230285_a_(Fluid p_230285_1_) {
        return p_230285_1_.func_207185_a((ITag)FluidTags.field_206960_b);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("is_Berserk", this.getIsBerserk());
        compound.func_74757_a("is_Awaken", this.getIsAwaken());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setIsBerserk(compound.func_74767_n("is_Berserk"));
        this.setIsAwaken(compound.func_74767_n("is_Awaken"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void setIsBerserk(boolean isBerserk) {
        this.func_184212_Q().func_187227_b(IS_BERSERK, (Object)isBerserk);
    }

    public boolean getIsBerserk() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_BERSERK);
    }

    public void setIsAwaken(boolean isAwaken) {
        this.func_184212_Q().func_187227_b(IS_AWAKEN, (Object)isAwaken);
    }

    public boolean getIsAwaken() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_AWAKEN);
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected int func_70682_h(int air) {
        return air;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        Entity entity;
        if (this.getAnimation() == MONSTROSITY_BERSERK && !source.func_76357_e()) {
            return false;
        }
        double range = this.calculateRange(source);
        if (range > CMConfig.MonstrosityLongRangelimit * CMConfig.MonstrosityLongRangelimit) {
            return false;
        }
        if (!source.func_76357_e()) {
            damage = Math.min((float)CMConfig.MonstrosityDamageCap, damage);
        }
        if ((entity = source.func_76364_f()) instanceof GolemEntity) {
            damage = (float)((double)damage * 0.5);
        }
        if (!this.field_70170_p.field_72995_K && !this.getIsAwaken()) {
            this.setIsAwaken(true);
        }
        return super.func_70097_a(source, damage);
    }

    public boolean func_241845_aY() {
        return this.func_70089_S() && this.Blocking;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    private void func_234318_eL() {
        if (this.func_180799_ab()) {
            ISelectionContext lvt_1_1_ = ISelectionContext.func_216374_a((Entity)this);
            if (lvt_1_1_.func_216378_a(FlowingFluidBlock.field_235510_c_, this.func_233580_cy_().func_177977_b(), true) && !this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177984_a()).func_206884_a((ITag)FluidTags.field_206960_b)) {
                this.field_70122_E = true;
            } else {
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.5).func_72441_c(0.0, (double)this.field_70146_Z.nextFloat() * 0.5, 0.0));
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_234318_eL();
        this.field_70177_z = this.field_70761_aq;
        if (!this.func_174814_R() && !this.field_70170_p.field_72995_K && this.getIsAwaken()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)67);
        }
        ++this.frame;
        float moveX = (float)(this.func_226277_ct_() - this.field_70169_q);
        float moveZ = (float)(this.func_226281_cx_() - this.field_70166_s);
        float speed = MathHelper.func_76129_c((float)(moveX * moveX + moveZ * moveZ));
        if (this.frame % 25 == 1 && (double)speed > 0.05 && this.getIsAwaken()) {
            this.func_184185_a((SoundEvent)ModSounds.MONSTROSITYSTEP.get(), 1.0f, 1.0f);
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        this.prevdeactivateProgress = this.deactivateProgress;
        if (!this.getIsAwaken() && this.deactivateProgress < 40.0f) {
            this.deactivateProgress = 40.0f;
        }
        if (this.getIsAwaken() && this.deactivateProgress > 0.0f) {
            this.deactivateProgress -= 1.0f;
            if (this.deactivateProgress == 20.0f && this.func_110143_aJ() > 0.0f) {
                this.func_184185_a((SoundEvent)ModSounds.MONSTROSITYAWAKEN.get(), 10.0f, 1.0f);
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        LivingEntity target = this.func_70638_az();
        if (this.getAnimation() == MONSTROSITY_EARTHQUAKE && this.getAnimationTick() == 34 || this.getAnimation() == MONSTROSITY_EARTHQUAKE2 && this.getAnimationTick() == 24 || this.getAnimation() == MONSTROSITY_EARTHQUAKE3 && this.getAnimationTick() == 29) {
            this.EarthQuake();
            ScreenShake_Entity.ScreenShake(this.field_70170_p, this.func_213303_ch(), 20.0f, 0.3f, 0, 20);
            this.Makeparticle(4.75f, 2.5f);
            this.Makeparticle(4.75f, -2.5f);
        }
        if (this.deactivateProgress == 0.0f && this.func_70089_S()) {
            if (!this.func_175446_cd() && this.getAnimation() == NO_ANIMATION && this.isBerserk() && !this.getIsBerserk()) {
                this.setAnimation(MONSTROSITY_BERSERK);
            } else if (!this.func_175446_cd() && this.getAnimation() == NO_ANIMATION && target != null && target.func_70089_S()) {
                if (this.func_180799_ab() && this.lavabombmagazine == 0) {
                    this.setAnimation(MONSTROSITY_CHARGE);
                } else if (!this.func_175446_cd() && this.getAnimation() == NO_ANIMATION && this.func_70032_d((Entity)target) >= 18.0f && this.func_70032_d((Entity)target) < 40.0f && this.lavabombmagazine > 0 && this.field_70146_Z.nextInt(48) == 0 || this.func_70032_d((Entity)target) > 4.75f && this.field_70146_Z.nextFloat() * 100.0f < 0.3f && this.func_70032_d((Entity)target) < 18.0f && this.lavabombmagazine > 0) {
                    this.setAnimation(MONSTROSITY_ERUPTIONATTACK);
                } else if (!this.func_175446_cd() && this.getAnimation() == NO_ANIMATION && this.func_70032_d((Entity)target) < 6.0f) {
                    Animation animation = Netherite_Monstrosity_Entity.getRandomAttack(this.field_70146_Z);
                    if (this.isBerserk()) {
                        this.setAnimation(MONSTROSITY_EARTHQUAKE2);
                    } else {
                        this.setAnimation(animation);
                    }
                }
            }
        }
        if (this.getAnimation() == MONSTROSITY_CHARGE) {
            if (this.getAnimationTick() == 34) {
                this.lavabombmagazine = CMConfig.Lavabombmagazine;
                this.doAbsorptionEffects(4, 1, 4);
                this.func_184185_a(SoundEvents.field_187633_N, 6.0f, 0.5f);
                this.func_70691_i(15.0f);
            }
            if (this.getAnimationTick() == 44) {
                this.doAbsorptionEffects(8, 2, 8);
                this.func_184185_a(SoundEvents.field_187633_N, 6.0f, 0.5f);
                this.func_70691_i(15.0f);
            }
            if (this.getAnimationTick() == 54) {
                this.doAbsorptionEffects(16, 4, 16);
                this.func_184185_a(SoundEvents.field_187633_N, 6.0f, 0.5f);
                this.func_70691_i(15.0f);
            }
        }
        if (this.getAnimation() == MONSTROSITY_BERSERK) {
            this.setIsBerserk(true);
            if (this.getAnimationTick() == 20) {
                this.func_184185_a((SoundEvent)ModSounds.MONSTROSITYGROWL.get(), 3.0f, 1.0f);
            }
            if (this.getAnimationTick() == 29) {
                this.berserkBlockBreaking(8, 8, 8);
                ScreenShake_Entity.ScreenShake(this.field_70170_p, this.func_213303_ch(), 20.0f, 0.3f, 0, 20);
                this.EarthQuake();
                this.Makeparticle(4.0f, 3.5f);
                this.Makeparticle(4.0f, -3.5f);
            }
        }
        if (!this.field_70170_p.field_72995_K && !this.getIsAwaken() && target != null) {
            this.setIsAwaken(true);
        }
    }

    public void setMaxHealth(double maxHealth, boolean heal) {
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(maxHealth);
        if (heal) {
            this.func_70691_i((float)maxHealth);
        }
    }

    @Override
    protected void onDeathAIUpdate() {
        super.onDeathAIUpdate();
        this.func_213293_j(0.0, this.func_213322_ci().field_72448_b, 0.0);
        if (this.field_70725_aQ == 68) {
            this.func_184185_a((SoundEvent)ModSounds.MONSTROSITYLAND.get(), 1.0f, 1.0f);
        }
    }

    private void doAbsorptionEffects(int x, int y, int z) {
        int MthX = MathHelper.func_76128_c((double)this.func_226277_ct_());
        int MthY = MathHelper.func_76128_c((double)this.func_226278_cu_());
        int MthZ = MathHelper.func_76128_c((double)this.func_226281_cx_());
        for (int k2 = -x; k2 <= x; ++k2) {
            for (int l2 = -z; l2 <= z; ++l2) {
                for (int j = -y; j <= y; ++j) {
                    int i3 = MthX + k2;
                    int k = MthY + j;
                    int l = MthZ + l2;
                    BlockPos blockpos = new BlockPos(i3, k, l);
                    this.doAbsorptionEffect(blockpos);
                }
            }
        }
    }

    private void doAbsorptionEffect(BlockPos pos) {
        BlockState state = this.field_70170_p.func_180495_p(pos);
        if (state.func_185904_a() == Material.field_151587_i) {
            this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    private void EarthQuake() {
        this.func_184185_a(SoundEvents.field_187539_bB, 1.5f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
        for (LivingEntity entity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(7.0))) {
            if (this.func_184191_r((Entity)entity) || entity instanceof Netherite_Monstrosity_Entity || entity == this) continue;
            boolean flag = entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_));
            if (entity instanceof PlayerEntity && entity.func_184585_cz()) {
                Netherite_Monstrosity_Entity.disableShield(entity, 120);
            }
            if (!flag) continue;
            this.launch((Entity)entity, true);
            if (!this.getIsBerserk()) continue;
            entity.func_70015_d(6);
        }
    }

    private void Makeparticle(float vec, float math) {
        if (this.field_70170_p.field_72995_K) {
            for (int i1 = 0; i1 < 80 + this.field_70146_Z.nextInt(12); ++i1) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                float f = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                float angle = (float)Math.PI / 180 * this.field_70761_aq + (float)i1;
                double extraX = 2.0f * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = 2.0f * MathHelper.func_76134_b((float)angle);
                double theta = (double)this.field_70761_aq * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.5707963267948966);
                double vecZ = Math.sin(theta);
                int hitX = MathHelper.func_76128_c((double)(this.func_226277_ct_() + (double)vec * vecX + extraX));
                int hitY = MathHelper.func_76128_c((double)this.func_226278_cu_());
                int hitZ = MathHelper.func_76128_c((double)(this.func_226281_cx_() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = this.field_70170_p.func_180495_p(hit.func_177977_b());
                if (this.getIsBerserk()) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() + (double)vec * vecX + extraX + (double)(f * math), this.func_226278_cu_() + extraY, this.func_226281_cx_() + (double)vec * vecZ + extraZ + (double)(f1 * math), motionX, motionY, motionZ);
                    continue;
                }
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, block), this.func_226277_ct_() + (double)vec * vecX + extraX + (double)(f * math), this.func_226278_cu_() + extraY, this.func_226281_cx_() + (double)vec * vecZ + extraZ + (double)(f1 * math), motionX, motionY, motionZ);
            }
        }
    }

    private void launch(Entity e, boolean huge) {
        double d0 = e.func_226277_ct_() - this.func_226277_ct_();
        double d1 = e.func_226281_cx_() - this.func_226281_cx_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        float f = huge ? 2.0f : 0.5f;
        e.func_70024_g(d0 / d2 * (double)f, huge ? 0.75 : (double)0.2f, d1 / d2 * (double)f);
    }

    private void berserkBlockBreaking(int x, int y, int z) {
        int MthX = MathHelper.func_76128_c((double)this.func_226277_ct_());
        int MthY = MathHelper.func_76128_c((double)this.func_226278_cu_());
        int MthZ = MathHelper.func_76128_c((double)this.func_226281_cx_());
        if (!this.field_70170_p.field_72995_K && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            for (int k2 = -x; k2 <= x; ++k2) {
                for (int l2 = -z; l2 <= z; ++l2) {
                    for (int j = 0; j <= y; ++j) {
                        int i3 = MthX + k2;
                        int k = MthY + j;
                        int l = MthZ + l2;
                        Block block = this.field_70170_p.func_180495_p(new BlockPos(i3, k, l)).func_177230_c();
                        TileEntity tileEntity = this.field_70170_p.func_175625_s(new BlockPos(i3, k, l));
                        if (block == Blocks.field_150350_a || BlockTags.func_199896_a().func_199910_a(ModTag.NETHERITE_MONSTROSITY_IMMUNE).func_230235_a_((Object)block)) continue;
                        if (tileEntity == null && this.field_70146_Z.nextInt(4) + 1 == 4) {
                            FallingBlockEntity fallingBlockEntity = new FallingBlockEntity(this.field_70170_p, (double)i3 + 0.5, (double)k + 0.5, (double)l + 0.5, block.func_176223_P());
                            fallingBlockEntity.func_213317_d(fallingBlockEntity.func_213322_ci().func_178787_e(this.func_213303_ch().func_178788_d(fallingBlockEntity.func_213303_ch()).func_216372_d((-1.2 + this.field_70146_Z.nextDouble()) / 3.0, (-1.1 + this.field_70146_Z.nextDouble()) / 3.0, (-1.2 + this.field_70146_Z.nextDouble()) / 3.0)));
                            this.field_70170_p.func_217376_c((Entity)fallingBlockEntity);
                            continue;
                        }
                        this.field_70170_p.func_175655_b(new BlockPos(i3, k, l), this.shouldDropItem(tileEntity));
                    }
                }
            }
        }
    }

    private boolean shouldDropItem(TileEntity tileEntity) {
        if (tileEntity == null) {
            return this.field_70146_Z.nextInt(3) + 1 == 3;
        }
        return true;
    }

    public boolean isBerserk() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 3.0f;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public ItemEntity func_199701_a_(ItemStack stack) {
        ItemEntity itementity = this.func_70099_a(stack, 0.0f);
        if (itementity != null) {
            itementity.func_213317_d(itementity.func_213322_ci().func_216372_d(0.0, 3.5, 0.0));
            itementity.func_184195_f(true);
            itementity.func_174873_u();
        }
        return itementity;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingData, @Nullable CompoundNBT compound) {
        this.setIsBerserk(false);
        this.setMaxHealth(CMConfig.MonstrosityHealth, true);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(CMConfig.MonstrosityDamage);
        return super.func_213386_a(world, difficulty, reason, livingData, compound);
    }

    public void func_213352_e(Vector3d travelVector) {
        this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_) * (this.func_180799_ab() ? 0.2f : 1.0f));
        if (this.func_70613_aW() && this.func_180799_ab()) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(travelVector);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.MONSTROSITYHURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSounds.MONSTROSITYDEATH.get();
    }

    protected BodyController func_184650_s() {
        return new SmartBodyHelper2((MobEntity)this);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new GroundPathNavigatorWide((MobEntity)this, this.field_70170_p);
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Override
    @Nullable
    public Animation getDeathAnimation() {
        return MONSTROSITY_DEATH;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 67) {
            cataclysm.PROXY.onEntityStatus((Entity)this, id);
        } else {
            super.func_70103_a(id);
        }
    }

    class AwakenGoal
    extends Goal {
        public AwakenGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return Netherite_Monstrosity_Entity.this.deactivateProgress > 0.0f;
        }

        public void func_75246_d() {
            Netherite_Monstrosity_Entity.this.func_213293_j(0.0, Netherite_Monstrosity_Entity.this.func_213322_ci().field_72448_b, 0.0);
        }
    }

    class HealGoal
    extends Goal {
        public HealGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return Netherite_Monstrosity_Entity.this.getAnimation() == MONSTROSITY_CHARGE;
        }

        public void func_75246_d() {
            LivingEntity target = Netherite_Monstrosity_Entity.this.func_70638_az();
            Netherite_Monstrosity_Entity.this.setAnimation(MONSTROSITY_CHARGE);
            Netherite_Monstrosity_Entity.this.func_213293_j(0.0, Netherite_Monstrosity_Entity.this.func_213322_ci().field_72448_b, 0.0);
            if (Netherite_Monstrosity_Entity.this.getAnimation() == MONSTROSITY_CHARGE && target != null) {
                if (Netherite_Monstrosity_Entity.this.getAnimationTick() < 34 || Netherite_Monstrosity_Entity.this.getAnimationTick() > 72) {
                    Netherite_Monstrosity_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                } else {
                    Netherite_Monstrosity_Entity.this.field_70177_z = Netherite_Monstrosity_Entity.this.field_70126_B;
                }
            }
        }
    }

    class BerserkGoal
    extends Goal {
        public BerserkGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return Netherite_Monstrosity_Entity.this.getAnimation() == MONSTROSITY_BERSERK;
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public void func_75246_d() {
            Netherite_Monstrosity_Entity.this.func_213293_j(0.0, Netherite_Monstrosity_Entity.this.func_213322_ci().field_72448_b, 0.0);
            LivingEntity target = Netherite_Monstrosity_Entity.this.func_70638_az();
            if (target != null) {
                Netherite_Monstrosity_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            }
        }
    }

    class ShootGoal
    extends Goal {
        public ShootGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return Netherite_Monstrosity_Entity.this.getAnimation() == MONSTROSITY_ERUPTIONATTACK;
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public void func_75246_d() {
            LivingEntity target = Netherite_Monstrosity_Entity.this.func_70638_az();
            Netherite_Monstrosity_Entity.this.func_213293_j(0.0, Netherite_Monstrosity_Entity.this.func_213322_ci().field_72448_b, 0.0);
            double lavabombcount = CMConfig.Lavabombamount;
            if (target != null) {
                Netherite_Monstrosity_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                if (Netherite_Monstrosity_Entity.this.getAnimationTick() == 30) {
                    Netherite_Monstrosity_Entity.this.func_184185_a((SoundEvent)ModSounds.MONSTROSITYSHOOT.get(), 3.0f, 0.75f);
                    Netherite_Monstrosity_Entity.this.lavabombmagazine--;
                    int i = 0;
                    while ((double)i < lavabombcount) {
                        Lava_Bomb_Entity lava = new Lava_Bomb_Entity((EntityType)ModEntities.LAVA_BOMB.get(), Netherite_Monstrosity_Entity.this.field_70170_p, (LivingEntity)Netherite_Monstrosity_Entity.this);
                        double d0 = target.func_226277_ct_() - Netherite_Monstrosity_Entity.this.func_226277_ct_();
                        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - lava.func_226278_cu_();
                        double d2 = target.func_226281_cx_() - Netherite_Monstrosity_Entity.this.func_226281_cx_();
                        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                        lava.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.0f, 24 - Netherite_Monstrosity_Entity.this.field_70170_p.func_175659_aa().func_151525_a() * 4);
                        Netherite_Monstrosity_Entity.this.field_70170_p.func_217376_c((Entity)lava);
                        ++i;
                    }
                }
            }
        }
    }

    class EarthQuakeGoal
    extends Goal {
        public EarthQuakeGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return Netherite_Monstrosity_Entity.this.getAnimation() == MONSTROSITY_EARTHQUAKE || Netherite_Monstrosity_Entity.this.getAnimation() == MONSTROSITY_EARTHQUAKE2 || Netherite_Monstrosity_Entity.this.getAnimation() == MONSTROSITY_EARTHQUAKE3;
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public void func_75246_d() {
            LivingEntity target = Netherite_Monstrosity_Entity.this.func_70638_az();
            Netherite_Monstrosity_Entity.this.func_213293_j(0.0, Netherite_Monstrosity_Entity.this.func_213322_ci().field_72448_b, 0.0);
            if (Netherite_Monstrosity_Entity.this.getAnimation() == MONSTROSITY_EARTHQUAKE) {
                if (Netherite_Monstrosity_Entity.this.getAnimationTick() < 34 && target != null || Netherite_Monstrosity_Entity.this.getAnimationTick() > 54 && target != null) {
                    Netherite_Monstrosity_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                } else {
                    Netherite_Monstrosity_Entity.this.field_70177_z = Netherite_Monstrosity_Entity.this.field_70126_B;
                }
            }
            if (Netherite_Monstrosity_Entity.this.getAnimation() == MONSTROSITY_EARTHQUAKE2) {
                if (Netherite_Monstrosity_Entity.this.getAnimationTick() < 24 && target != null || Netherite_Monstrosity_Entity.this.getAnimationTick() > 44 && target != null) {
                    Netherite_Monstrosity_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                } else {
                    Netherite_Monstrosity_Entity.this.field_70177_z = Netherite_Monstrosity_Entity.this.field_70126_B;
                }
            }
            if (Netherite_Monstrosity_Entity.this.getAnimation() == MONSTROSITY_EARTHQUAKE3) {
                if (Netherite_Monstrosity_Entity.this.getAnimationTick() < 29 && target != null || Netherite_Monstrosity_Entity.this.getAnimationTick() > 49 && target != null) {
                    Netherite_Monstrosity_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                } else {
                    Netherite_Monstrosity_Entity.this.field_70177_z = Netherite_Monstrosity_Entity.this.field_70126_B;
                }
            }
        }
    }
}

