/*
 * Decompiled with CFR 0.152.
 */
package L_Ender.cataclysm.structures;

import L_Ender.cataclysm.structures.SoulBlackSmithPieces;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public class SoulBlackSmithStructure
extends Structure<NoFeatureConfig> {
    public SoulBlackSmithStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    protected boolean func_230363_a_(ChunkGenerator generator, BiomeProvider provider, long seed, SharedSeedRandom random, int x, int z, Biome biome, ChunkPos chunkPos, NoFeatureConfig config) {
        int i = x >> 4;
        int j = z >> 4;
        random.setSeed((long)(i ^ j << 4) ^ seed);
        random.nextInt();
        return !this.isNetherStructureWithin(generator, seed, random, x, z, 10);
    }

    private boolean isNetherStructureWithin(ChunkGenerator generator, long seed, SharedSeedRandom random, int x, int z, int radius) {
        StructureSeparationSettings structureseparationsettings = generator.func_235957_b_().func_236197_a_(Structure.field_236378_n_);
        StructureSeparationSettings structureseparationsettings2 = generator.func_235957_b_().func_236197_a_(Structure.field_236383_s_);
        if (structureseparationsettings != null && structureseparationsettings2 != null) {
            for (int surroundingX = x - radius; surroundingX <= x + radius; ++surroundingX) {
                for (int surroundingZ = z - radius; surroundingZ <= z + radius; ++surroundingZ) {
                    ChunkPos chunkpos = Structure.field_236378_n_.func_236392_a_(structureseparationsettings, seed, random, surroundingX, surroundingZ);
                    ChunkPos chunkpos2 = Structure.field_236383_s_.func_236392_a_(structureseparationsettings, seed, random, surroundingX, surroundingZ);
                    if ((surroundingX != chunkpos.field_77276_a || surroundingZ != chunkpos.field_77275_b) && (surroundingX != chunkpos2.field_77276_a || surroundingZ != chunkpos2.field_77275_b)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void func_230364_a_(DynamicRegistries dynamicRegistryManager, ChunkGenerator generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            int x = (chunkX << 4) + 7;
            int z = (chunkZ << 4) + 7;
            BlockPos blockpos = new BlockPos(x, 27, z);
            SoulBlackSmithPieces.start(templateManagerIn, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
        }
    }
}

