/*
 * Decompiled with CFR 0.152.
 */
package L_Ender.cataclysm.tileentities;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.server.ServerWorld;

public abstract class TileEntityBossSpawner<T extends MobEntity>
extends TileEntity
implements ITickableTileEntity {
    protected static final int SHORT_RANGE = 6;
    protected static final int LONG_RANGE = 50;
    protected final EntityType<T> entityType;
    protected boolean spawnedBoss = false;

    protected TileEntityBossSpawner(TileEntityType<?> type, EntityType<T> entityType) {
        super(type);
        this.entityType = entityType;
    }

    public boolean anyPlayerInRange() {
        return this.field_145850_b.func_217358_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, (double)this.getRange());
    }

    public void func_73660_a() {
        if (this.spawnedBoss || !this.anyPlayerInRange()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            double rx = (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat();
            double ry = (float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat();
            double rz = (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat();
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, rx, ry, rz, 0.0, 0.0, 0.0);
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197631_x, rx, ry, rz, 0.0, 0.0, 0.0);
        } else if (this.field_145850_b.func_175659_aa() != Difficulty.PEACEFUL && this.spawnMyBoss((IServerWorld)((ServerWorld)this.field_145850_b))) {
            this.field_145850_b.func_175655_b(this.field_174879_c, false);
            this.spawnedBoss = true;
        }
    }

    protected boolean spawnMyBoss(IServerWorld world) {
        T myCreature = this.makeMyCreature();
        myCreature.func_174828_a(this.field_174879_c, world.func_201672_e().field_73012_v.nextFloat() * 360.0f, 0.0f);
        myCreature.func_213386_a(world, world.func_175649_E(this.field_174879_c), SpawnReason.SPAWNER, null, null);
        this.initializeCreature(myCreature);
        return world.func_217376_c(myCreature);
    }

    protected void initializeCreature(T myCreature) {
        myCreature.func_213390_a(this.field_174879_c, 46);
    }

    protected int getRange() {
        return 6;
    }

    protected T makeMyCreature() {
        return (T)((MobEntity)this.entityType.func_200721_a(this.field_145850_b));
    }
}

