/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.data;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.ICollectionData;
import com.blamejared.crafttweaker.api.data.INumberData;
import com.blamejared.crafttweaker.impl.data.BoolData;
import com.blamejared.crafttweaker.impl.data.ByteData;
import com.blamejared.crafttweaker.impl.data.IntData;
import com.blamejared.crafttweaker.impl.data.ListData;
import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="crafttweaker.api.data.IData")
@ZenRegister
@Document(value="vanilla/api/data/IData")
public interface IData {
    public static final TextFormatting SYNTAX_HIGHLIGHTING_KEY = TextFormatting.AQUA;
    public static final TextFormatting SYNTAX_HIGHLIGHTING_STRING = TextFormatting.GREEN;
    public static final TextFormatting SYNTAX_HIGHLIGHTING_QUOTE = TextFormatting.GRAY;
    public static final TextFormatting SYNTAX_HIGHLIGHTING_NUMBER = TextFormatting.GOLD;
    public static final TextFormatting SYNTAX_HIGHLIGHTING_TYPE = TextFormatting.RED;
    public static final TextFormatting SYNTAX_HIGHLIGHTING_AS = TextFormatting.GRAY;

    @ZenCodeType.Method
    default public byte getId() {
        return this.getInternal().func_74732_a();
    }

    @ZenCodeType.Method
    public IData copy();

    public IData copyInternal();

    public INBT getInternal();

    @ZenCodeType.Method
    default public String getString() {
        return this.getInternal().func_150285_a_();
    }

    @ZenCodeType.Method
    default public boolean contains(IData data) {
        return this.getInternal().equals(data.getInternal());
    }

    @ZenCodeType.Method
    default public Map<String, IData> asMap() {
        return null;
    }

    @ZenCodeType.Method
    default public List<IData> asList() {
        return null;
    }

    @ZenCodeType.Method
    public String asString();

    default public ITextComponent asFormattedComponent(String indentation, int indentDepth) {
        return new StringTextComponent(this.toJsonString());
    }

    @ZenCodeType.Method
    default public MCTextComponent asFormattedText(String indentation, int indentDepth) {
        return new MCTextComponent(this.asFormattedComponent(indentation, indentDepth));
    }

    public String toJsonString();

    @ZenCodeType.Caster
    @ZenCodeType.Method
    default public INumberData asNumber() {
        if (this instanceof INumberData) {
            return (INumberData)this;
        }
        return new IntData(0);
    }

    @ZenCodeType.Caster
    @ZenCodeType.Method
    default public ICollectionData asCollection() {
        if (this instanceof ICollectionData) {
            return (ICollectionData)this;
        }
        return new ListData();
    }

    @ZenCodeType.Caster
    @ZenCodeType.Method
    default public boolean asBoolean() {
        if (this instanceof BoolData) {
            return ((BoolData)this).getInternalValue();
        }
        if (this instanceof ByteData) {
            return ((ByteData)this).getByte() == 1;
        }
        return false;
    }
}

