/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.data;

import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.impl.data.BoolData;
import com.blamejared.crafttweaker.impl.data.ByteData;
import com.blamejared.crafttweaker.impl.data.DoubleData;
import com.blamejared.crafttweaker.impl.data.FloatData;
import com.blamejared.crafttweaker.impl.data.IntData;
import com.blamejared.crafttweaker.impl.data.ListData;
import com.blamejared.crafttweaker.impl.data.LongData;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.data.ShortData;
import com.blamejared.crafttweaker.impl.data.StringData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.openzen.zencode.shared.LiteralSourceFile;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSToken;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.lexer.ZSTokenType;

public class StringConverter {
    public static IData convert(String expression) throws ParseException {
        try {
            ZSTokenParser parser = ZSTokenParser.create(new LiteralSourceFile("", expression), null);
            return StringConverter.parse(parser);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static IData parse(ZSTokenParser parser) throws ParseException {
        IData base;
        ZSToken next = (ZSToken)parser.next();
        switch (next.getType()) {
            case T_AOPEN: {
                base = StringConverter.parseMap(parser);
                break;
            }
            case T_SQOPEN: {
                base = StringConverter.parseList(parser);
                break;
            }
            case K_TRUE: {
                base = new BoolData(true);
                break;
            }
            case K_FALSE: {
                base = new BoolData(false);
                break;
            }
            case T_INT: {
                base = new LongData(Long.parseLong(next.getContent(), 10));
                break;
            }
            case T_FLOAT: {
                base = new DoubleData(Double.parseDouble(next.getContent()));
                break;
            }
            case T_STRING_DQ: 
            case T_STRING_DQ_WYSIWYG: {
                base = new StringData(next.getContent());
                break;
            }
            default: {
                throw new ParseException(parser.getPosition().withLength(next.getContent().length()), "Could not resolve Data near " + next.getContent());
            }
        }
        if (parser.optional(ZSTokenType.K_AS) != null) {
            ZSToken token = (ZSToken)parser.next();
            switch (token.getType()) {
                case K_BOOL: {
                    return new BoolData(base.asNumber().getInt() == 1);
                }
                case K_BYTE: {
                    return new ByteData(base.asNumber().getByte());
                }
                case K_SHORT: {
                    return new ShortData(base.asNumber().getShort());
                }
                case K_INT: {
                    return new IntData(base.asNumber().getInt());
                }
                case K_LONG: {
                    return new LongData(base.asNumber().getLong());
                }
                case K_FLOAT: {
                    return new FloatData(base.asNumber().getFloat());
                }
                case K_DOUBLE: {
                    return new DoubleData(base.asNumber().getDouble());
                }
                case K_STRING: {
                    if (base instanceof StringData) {
                        return base;
                    }
                    return new StringData(base.toJsonString());
                }
                case T_IDENTIFIER: {
                    return base;
                }
            }
        }
        return base;
    }

    private static IData parseList(ZSTokenParser parser) throws ParseException {
        ArrayList<IData> result = new ArrayList<IData>();
        while (parser.optional(ZSTokenType.T_SQCLOSE) == null) {
            result.add(StringConverter.parse(parser));
            if (parser.optional(ZSTokenType.T_COMMA) != null) continue;
            parser.required(ZSTokenType.T_SQCLOSE, "] expected");
            break;
        }
        return new ListData(result);
    }

    private static IData parseMap(ZSTokenParser parser) throws ParseException {
        HashMap<String, IData> result = new HashMap<String, IData>();
        while (parser.optional(ZSTokenType.T_ACLOSE) == null) {
            String key;
            ZSTokenType tokenType = ((ZSToken)parser.peek()).getType();
            switch (tokenType) {
                case T_STRING_DQ: 
                case T_STRING_DQ_WYSIWYG: {
                    String content = ((ZSToken)parser.required(tokenType, "String expected")).getContent();
                    key = content.substring(1, content.length() - 1);
                    break;
                }
                default: {
                    key = ((ZSToken)parser.required(ZSTokenType.T_IDENTIFIER, "Identifier expected")).getContent();
                }
            }
            parser.required(ZSTokenType.T_COLON, ": expected");
            result.put(key, StringConverter.parse(parser));
            if (parser.optional(ZSTokenType.T_COMMA) != null) continue;
            parser.required(ZSTokenType.T_ACLOSE, "} expected");
            break;
        }
        return new MapData(result);
    }
}

