/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipes;

import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;

public interface IRecipeHandler<T extends IRecipe<?>> {
    public static <S extends IRecipe<?>, U> Optional<U> attemptReplacing(U ingredient, Class<U> type, S recipe, List<IReplacementRule> rules) {
        BinaryOperator combiner = (oldOpt, newOpt) -> newOpt.isPresent() ? newOpt : oldOpt;
        return rules.stream().reduce(Optional.empty(), (optional, rule) -> (Optional)combiner.apply(optional, rule.getReplacement(optional.orElse(ingredient), type, recipe)), combiner);
    }

    public String dumpToCommandString(IRecipeManager var1, T var2);

    default public Optional<Function<ResourceLocation, T>> replaceIngredients(IRecipeManager manager, T recipe, List<IReplacementRule> rules) throws ReplacementNotSupportedException {
        throw new ReplacementNotSupportedException("Replacement is not supported for the recipe class '" + recipe.getClass().getName() + "' with manager " + manager.getCommandString());
    }

    default public <U extends IRecipe<?>> boolean doesConflict(IRecipeManager manager, T firstRecipe, U secondRecipe) {
        return false;
    }

    public static class ReplacementNotSupportedException
    extends Exception {
        public ReplacementNotSupportedException(String message) {
            super(message);
        }

        public ReplacementNotSupportedException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @Documented
    @Repeatable(value=Container.class)
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface For {
        public Class<? extends IRecipe<?>> value();

        @Documented
        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.TYPE})
        public static @interface Container {
            public For[] value();
        }
    }
}

