/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class AttributeUtil {
    public static void addAttributeModifier(ItemStack stack, Attribute attributeName, AttributeModifier modifier, @Nullable EquipmentSlotType equipmentSlot) {
        CompoundNBT tag = stack.func_190925_c("CraftTweakerData");
        if (!tag.func_150297_b("AttributeModifiers", 9)) {
            tag.func_218657_a("AttributeModifiers", (INBT)new ListNBT());
        }
        ListNBT listnbt = tag.func_150295_c("AttributeModifiers", 10);
        CompoundNBT compoundnbt = modifier.func_233801_e_();
        compoundnbt.func_74778_a("AttributeName", Registry.field_239692_aP_.func_177774_c((Object)attributeName).toString());
        if (equipmentSlot != null) {
            compoundnbt.func_74778_a("Slot", equipmentSlot.func_188450_d());
        }
        listnbt.add((Object)compoundnbt);
    }

    public static Map<Attribute, List<AttributeModifier>> getAttributeModifiers(ItemStack stack, EquipmentSlotType equipmentSlot) {
        HashMap<Attribute, List<AttributeModifier>> map = new HashMap<Attribute, List<AttributeModifier>>();
        CompoundNBT tag = stack.func_179543_a("CraftTweakerData");
        if (tag == null || !tag.func_150297_b("AttributeModifiers", 9)) {
            return map;
        }
        ListNBT listnbt = tag.func_150295_c("AttributeModifiers", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            if (compoundnbt.func_150297_b("Slot", 8) && !compoundnbt.func_74779_i("Slot").equals(equipmentSlot.func_188450_d())) continue;
            Optional optional = Registry.field_239692_aP_.func_241873_b(ResourceLocation.func_208304_a((String)compoundnbt.func_74779_i("AttributeName")));
            optional.ifPresent(attribute -> {
                AttributeModifier attributemodifier = AttributeModifier.func_233800_a_((CompoundNBT)compoundnbt);
                if (attributemodifier != null && attributemodifier.func_111167_a().getLeastSignificantBits() != 0L && attributemodifier.func_111167_a().getMostSignificantBits() != 0L) {
                    map.computeIfAbsent((Attribute)attribute, key -> new ArrayList()).add(attributemodifier);
                }
            });
        }
        return map;
    }
}

