/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.zencode.impl.preprocessors.snipping;

import com.blamejared.crafttweaker.api.zencode.impl.FileAccessSingle;
import com.blamejared.crafttweaker.api.zencode.impl.preprocessors.snipping.SnippingParameterHit;
import java.util.ArrayList;
import java.util.List;
import org.openzen.zencode.shared.CodePosition;

final class SnippingMatch {
    private final CodePosition start;
    private final SnippingMatch parent;
    private final List<SnippingMatch> children;
    private final String name;
    private final SnippingParameterHit parameterHit;
    private CodePosition end;

    SnippingMatch(CodePosition start, String name, SnippingMatch parent, SnippingParameterHit parameterHit) {
        this.start = start;
        this.name = name;
        this.parameterHit = parameterHit;
        this.children = new ArrayList<SnippingMatch>();
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    private static String snipInLine(String lineContent, int startColumn, int endColumn) {
        char[] chars = lineContent.toCharArray();
        for (int i = startColumn; i < endColumn; ++i) {
            chars[i] = 32;
        }
        return new String(chars);
    }

    public CodePosition getStart() {
        return this.start;
    }

    public CodePosition getEnd() {
        return this.end;
    }

    public void setEnd(CodePosition end) {
        this.end = end;
    }

    public SnippingMatch getParent() {
        return this.parent;
    }

    private void addChild(SnippingMatch child) {
        this.children.add(child);
    }

    public String getName() {
        return this.name;
    }

    public void snip(FileAccessSingle file) {
        if (this.parameterHit.shouldSnip) {
            this.snipComplete(file);
        } else {
            this.snipPreprocessorCallsOnly(file);
            this.snipChildren(file);
        }
    }

    private void snipPreprocessorCallsOnly(FileAccessSingle file) {
        List<String> fileContents = file.getFileContents();
        int position = this.start.fromLine - 1;
        int snipStart = this.start.fromLineOffset;
        int snipEnd = this.start.toLineOffset;
        String toSnip = fileContents.get(position);
        String snipped = SnippingMatch.snipInLine(toSnip, snipStart, snipEnd);
        fileContents.set(position, snipped);
        position = this.end.fromLine - 1;
        snipStart = this.end.fromLineOffset;
        snipEnd = this.end.toLineOffset;
        toSnip = fileContents.get(position);
        snipped = SnippingMatch.snipInLine(toSnip, snipStart, snipEnd);
        fileContents.set(position, snipped);
    }

    private void snipComplete(FileAccessSingle file) {
        for (int i = this.start.fromLine; i <= this.end.toLine; ++i) {
            this.snipLine(i, file);
        }
    }

    private void snipLine(int lineNumber, FileAccessSingle file) {
        List<String> fileContents = file.getFileContents();
        int position = lineNumber - 1;
        String toSnip = fileContents.get(position);
        int snipStart = lineNumber != this.start.fromLine ? 0 : this.start.fromLineOffset;
        int snipEnd = lineNumber != this.end.toLine ? toSnip.length() : this.end.toLineOffset;
        String snipped = SnippingMatch.snipInLine(toSnip, snipStart, snipEnd);
        fileContents.set(position, snipped);
    }

    private void snipChildren(FileAccessSingle file) {
        for (SnippingMatch child : this.children) {
            child.snip(file);
        }
    }
}

