/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.zencode.impl.registry;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.BracketDumper;
import com.blamejared.crafttweaker.api.annotations.BracketResolver;
import com.blamejared.crafttweaker.api.annotations.BracketValidator;
import com.blamejared.crafttweaker.api.zencode.brackets.ValidatedEscapableBracketParser;
import com.blamejared.crafttweaker.impl.commands.BracketDumperInfo;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openzen.zencode.java.ScriptingEngine;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.java.module.JavaNativeModule;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;

public class BracketResolverRegistry {
    private final Map<String, Method> bracketResolvers = new HashMap<String, Method>();
    private final Map<String, Collection<String>> bracketNamesByRootPackage = new HashMap<String, Collection<String>>();
    private final Map<String, Method> bracketValidators = new HashMap<String, Method>();
    private final Set<String> advancedBepNames = new HashSet<String>();
    private final Map<String, BracketDumperInfo> bracketDumpers = new HashMap<String, BracketDumperInfo>();

    public void validateBrackets() {
        for (String validatedBep : this.bracketValidators.keySet()) {
            if (this.bracketResolvers.containsKey(validatedBep) || this.advancedBepNames.contains(validatedBep)) continue;
            CraftTweakerAPI.logError("BEP %s has a validator but no BEP method", validatedBep);
        }
    }

    public void addClasses(List<Class<?>> clsList) {
        for (Class<?> cls : clsList) {
            for (Method method : cls.getMethods()) {
                this.addMethod(method);
            }
        }
    }

    public void addMethod(Method method) {
        if (method.isAnnotationPresent(BracketResolver.class)) {
            this.addBracketResolver(method);
        }
        if (method.isAnnotationPresent(BracketDumper.class)) {
            this.addBracketDumper(method);
        }
        if (method.isAnnotationPresent(BracketValidator.class)) {
            this.addBracketValidator(method);
        }
    }

    public Method getBracketValidator(String bepName) {
        return this.bracketValidators.getOrDefault(bepName, null);
    }

    public void addAdvancedBEPName(String name) {
        this.advancedBepNames.add(name);
    }

    public Map<String, BracketDumperInfo> getBracketDumpers() {
        return ImmutableMap.copyOf(this.bracketDumpers);
    }

    public List<ValidatedEscapableBracketParser> getBracketResolvers(String name, ScriptingEngine scriptingEngine, JavaNativeModule owningModule) {
        ArrayList<ValidatedEscapableBracketParser> validatedEscapableBracketParsers = new ArrayList<ValidatedEscapableBracketParser>();
        for (String bepName : (Collection)this.bracketNamesByRootPackage.getOrDefault(name, Collections.emptyList())) {
            Method parserMethod = this.bracketResolvers.get(bepName);
            Method validatorMethod = this.getBracketValidator(bepName);
            FunctionalMemberRef functionalMemberRef = owningModule.loadStaticMethod(parserMethod);
            ValidatedEscapableBracketParser validated = new ValidatedEscapableBracketParser(bepName, functionalMemberRef, validatorMethod, scriptingEngine.registry);
            validatedEscapableBracketParsers.add(validated);
        }
        return validatedEscapableBracketParsers;
    }

    private void addBracketResolver(Method method) {
        if (!Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
            CraftTweakerAPI.logWarning("Method \"%s\" is marked as a BracketResolver, but it is not public and static.", method.toString());
            return;
        }
        boolean isValid = true;
        Class<?>[] parameters = method.getParameterTypes();
        String name = method.getAnnotation(BracketResolver.class).value();
        if (parameters.length != 1 || !parameters[0].equals(String.class)) {
            CraftTweakerAPI.logError("Method \"%s\" is marked as a BracketResolver, but it does not have a String as it's only parameter.", method.toString());
            isValid = false;
        }
        if (!this.bracketResolvers.getOrDefault(name, method).equals(method)) {
            Method other = this.bracketResolvers.get(name);
            CraftTweakerAPI.logError("BracketResolve \"%s\" was registered twice: '%s' and '%s'", name, other, method);
            isValid = false;
        }
        if (isValid) {
            this.bracketResolvers.put(name, method);
            Class<?> cls = method.getDeclaringClass();
            String clsName = cls.isAnnotationPresent(ZenCodeType.Name.class) ? cls.getAnnotation(ZenCodeType.Name.class).value() : cls.getCanonicalName();
            this.bracketNamesByRootPackage.computeIfAbsent(clsName.split("[.]", 2)[0], s -> new ArrayList()).add(name);
        }
    }

    private void addBracketDumper(Method method) {
        if (!Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
            CraftTweakerAPI.logWarning("Method \"%s\" is marked as a BracketDumper, but it is not public and static.", method.toString());
            return;
        }
        if (method.getParameterCount() != 0) {
            CraftTweakerAPI.logWarning("Method \"%s\" is marked as BracketDumper but does not have 0 parameters.", method.toString());
            return;
        }
        if (!Collection.class.isAssignableFrom(method.getReturnType()) || ((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0] != String.class) {
            CraftTweakerAPI.logWarning("Method \"%s\" is marked as BracketDumper but does not have 'Collection<String>' as return type.", method.toGenericString());
            return;
        }
        BracketDumper annotation = method.getAnnotation(BracketDumper.class);
        try {
            MethodHandle methodHandle = MethodHandles.publicLookup().unreflect(method);
            BracketDumperInfo dumperInfo = this.bracketDumpers.computeIfAbsent(annotation.value(), bepName -> new BracketDumperInfo((String)bepName, annotation.subCommandName(), annotation.fileName()));
            dumperInfo.addMethodHandle(methodHandle);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void addBracketValidator(Method method) {
        if (!Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
            CraftTweakerAPI.logWarning("Method \"%s\" is marked as a BracketValidator, but it is not public and static.", method.toString());
            return;
        }
        boolean valid = true;
        String value = method.getAnnotation(BracketValidator.class).value();
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters.length != 1 || !parameters[0].equals(String.class)) {
            CraftTweakerAPI.logError("Method \"%s\" is marked as a BracketValidator, but it does not have a String as it's only parameter.", method.toString());
            valid = false;
        }
        if (this.bracketValidators.containsKey(value)) {
            CraftTweakerAPI.logError("Bracket validator for bep name %s was found twice: %s and %s", value, this.bracketValidators.get(value), method);
            valid = false;
        }
        if (method.getReturnType() != Boolean.TYPE) {
            CraftTweakerAPI.logError("Method \"%s\" is marked as a BracketValidator, so it must return a boolean", method);
            valid = false;
        }
        if (valid) {
            this.bracketValidators.put(value, method);
        }
    }
}

