/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.brewing;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.impl.actions.brewing.ActionBrewingBase;
import com.blamejared.crafttweaker.impl_native.potion.ExpandPotion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.registries.IRegistryDelegate;

public class ActionRemoveBrewingRecipeByPotionInput
extends ActionBrewingBase {
    private final List<PotionBrewing.MixPredicate<Potion>> removed = new ArrayList<PotionBrewing.MixPredicate<Potion>>();
    private final Potion input;

    public ActionRemoveBrewingRecipeByPotionInput(List<IBrewingRecipe> recipes, Potion input) {
        super(recipes);
        this.input = input;
    }

    @Override
    public void apply() {
        Iterator iterator = PotionBrewing.field_185213_a.iterator();
        while (iterator.hasNext()) {
            PotionBrewing.MixPredicate mix = (PotionBrewing.MixPredicate)iterator.next();
            IRegistryDelegate potionInput = mix.field_185198_a;
            if (potionInput == null) {
                throw new RuntimeException("Error getting potion from mix: " + mix + "! Please make an issue on the issue tracker!");
            }
            if (!((Potion)potionInput.get()).getRegistryName().equals((Object)this.input.getRegistryName())) continue;
            this.removed.add((PotionBrewing.MixPredicate<Potion>)mix);
            iterator.remove();
        }
    }

    @Override
    public void undo() {
        for (PotionBrewing.MixPredicate<Potion> potion : this.removed) {
            Ingredient itemReagent = this.getItemReagent(potion);
            IRegistryDelegate potionOutput = potion.field_185200_c;
            if (potion.field_185198_a == null || itemReagent == null || potionOutput == null) {
                CraftTweakerAPI.logError("Error getting mix entries! potionInput: %s, itemReagent: %s, potionOutput: %s", potion.field_185198_a, itemReagent, potionOutput);
                continue;
            }
            PotionBrewing.func_193357_a((Potion)((Potion)potion.field_185198_a.get()), (Item)itemReagent.func_193365_a()[0].func_77973_b(), (Potion)((Potion)potionOutput.get()));
        }
    }

    @Override
    public String describe() {
        return "Removing Brewing recipes that have an input of: " + ExpandPotion.getCommandString(this.input);
    }

    @Override
    public String describeUndo() {
        return "Undoing removal of Brewing recipes that have an input of: " + ExpandPotion.getCommandString(this.input);
    }
}

