/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.loot;

import com.blamejared.crafttweaker.impl.actions.loot.ActionLootModifier;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.IGlobalLootModifier;

public class ActionRemoveLootModifier
extends ActionLootModifier {
    private final String description;
    private final Predicate<Map.Entry<ResourceLocation, IGlobalLootModifier>> removalPredicate;

    public ActionRemoveLootModifier(Predicate<Map.Entry<ResourceLocation, IGlobalLootModifier>> removalPredicate, String description, Supplier<Map<ResourceLocation, IGlobalLootModifier>> mapGetter) {
        super(mapGetter);
        this.description = description;
        this.removalPredicate = removalPredicate;
    }

    public static ActionRemoveLootModifier of(Predicate<ResourceLocation> removalPredicate, String description, Supplier<Map<ResourceLocation, IGlobalLootModifier>> mapGetter) {
        return new ActionRemoveLootModifier(entry -> removalPredicate.test((ResourceLocation)entry.getKey()), description, mapGetter);
    }

    @Override
    public void apply() {
        Map<ResourceLocation, IGlobalLootModifier> map = this.getModifiersMap();
        map.entrySet().stream().filter(this.removalPredicate).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(map::remove);
    }

    @Override
    public String describe() {
        return this.description == null ? "Removing all loot modifiers" : "Removing loot modifiers " + this.description;
    }
}

