/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.recipes;

import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRecipeBase;
import java.util.regex.Pattern;

public class ActionRemoveRecipeByRegex
extends ActionRecipeBase {
    private final Pattern compiledPat;
    private final IRecipeManager.RecipeFilter exclude;

    public ActionRemoveRecipeByRegex(IRecipeManager manager, String regex) {
        super(manager);
        this.compiledPat = Pattern.compile(regex);
        this.exclude = name -> false;
    }

    public ActionRemoveRecipeByRegex(IRecipeManager manager, String regex, IRecipeManager.RecipeFilter exclude) {
        super(manager);
        this.compiledPat = Pattern.compile(regex);
        this.exclude = exclude;
    }

    @Override
    public void apply() {
        this.getRecipes().keySet().removeIf(resourceLocation -> this.compiledPat.matcher(resourceLocation.toString()).matches() && !this.exclude.test(resourceLocation.func_110623_a()));
    }

    @Override
    public String describe() {
        return "Removing \"" + this.getRecipeTypeName() + "\" recipe with names that match the regex: \"" + this.compiledPat.pattern() + "\"";
    }
}

