/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.tags;

import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTag;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class ActionTagModify<T extends ForgeRegistryEntry<?>>
extends ActionTag<T> {
    protected final List<T> values;

    public ActionTagModify(ITag<T> tag, List<T> values, MCTag<?> mcTag) {
        super(tag, mcTag);
        this.values = values;
    }

    @Override
    public void apply() {
        if (!(this.tag instanceof Tag)) {
            throw new RuntimeException("Only Tag's are supported right now, can't act on: " + this.tag);
        }
        ArrayList list = new ArrayList(((Tag)this.tag).field_241282_b_);
        HashSet set = new HashSet(((Tag)this.tag).field_241283_c_);
        this.applyTo(list, set);
        ((Tag)this.tag).field_241282_b_ = ImmutableList.copyOf(list);
        ((Tag)this.tag).field_241283_c_ = set;
        ((Tag)this.tag).field_241281_a_ = Tag.func_241287_c_(set);
    }

    protected abstract void applyTo(List<T> var1, Set<T> var2);

    public List<T> getValues() {
        return this.values;
    }

    @Override
    public boolean validate(ILogger logger) {
        if (this.getValues() == null) {
            logger.throwingErr("Tag entries cannot be null!", new NullPointerException("Tag entries cannot be null!"));
            return false;
        }
        if (this.getValues().size() == 0) {
            logger.throwingErr("Tag entries cannot be empty!", new IndexOutOfBoundsException("Tag entries cannot be empty!"));
        }
        return super.validate(logger);
    }

    public String describeValues() {
        return this.getValues().stream().map(Objects::toString).collect(Collectors.joining(",", "[", "]"));
    }
}

