/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.brackets;

import com.blamejared.crafttweaker.CraftTweaker;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.util.InstantiationUtil;
import com.blamejared.crafttweaker.impl.brackets.util.ParseUtil;
import com.blamejared.crafttweaker.impl.managers.RecipeManagerWrapper;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.util.Lazy;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.parser.BracketExpressionParser;
import org.openzen.zenscript.parser.expression.ParsedCallArguments;
import org.openzen.zenscript.parser.expression.ParsedExpression;
import org.openzen.zenscript.parser.expression.ParsedExpressionCall;
import org.openzen.zenscript.parser.expression.ParsedExpressionCast;
import org.openzen.zenscript.parser.expression.ParsedExpressionMember;
import org.openzen.zenscript.parser.expression.ParsedExpressionString;
import org.openzen.zenscript.parser.expression.ParsedExpressionVariable;
import org.openzen.zenscript.parser.type.IParsedType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.RecipeTypeBracketHandler")
public class RecipeTypeBracketHandler
implements BracketExpressionParser {
    private static final Set<Lazy<IRecipeType<?>>> FILTERED_TYPES = ImmutableSet.of((Object)Lazy.concurrentOf(() -> CraftTweaker.RECIPE_TYPE_SCRIPTS));
    private static final Map<IRecipeType<?>, IRecipeManager> registeredTypes = new HashMap();
    private static final Map<Class<? extends IRecipeManager>, IRecipeManager> managerInstances = new HashMap<Class<? extends IRecipeManager>, IRecipeManager>();

    public RecipeTypeBracketHandler(List<Class<? extends IRecipeManager>> recipeManagers) {
        registeredTypes.clear();
        for (Class<? extends IRecipeManager> recipeManager : recipeManagers) {
            this.registerRecipeManager(recipeManager);
        }
    }

    @Deprecated
    public static boolean containsCustomManager(ResourceLocation location) {
        return registeredTypes.containsKey(RecipeTypeBracketHandler.lookup(location));
    }

    @Deprecated
    public static IRecipeManager getCustomManager(ResourceLocation location) {
        return registeredTypes.get(RecipeTypeBracketHandler.lookup(location));
    }

    public static Collection<IRecipeManager> getManagerInstances() {
        return managerInstances.values();
    }

    public static IRecipeManager getOrDefault(ResourceLocation location) {
        return RecipeTypeBracketHandler.getOrDefault(RecipeTypeBracketHandler.lookup(location));
    }

    public static IRecipeManager getOrDefault(IRecipeType<?> type) {
        if (FILTERED_TYPES.stream().anyMatch(it -> type == it.get())) {
            return null;
        }
        return registeredTypes.computeIfAbsent(type, RecipeManagerWrapper::makeOrNull);
    }

    @ZenCodeType.Method
    public static <T extends IRecipeManager> T getRecipeManager(String location) {
        IRecipeType<?> recipeType = RecipeTypeBracketHandler.lookup(new ResourceLocation(location));
        if (recipeType == null) {
            throw new IllegalArgumentException("Unknown recipe type: " + location);
        }
        return (T)registeredTypes.get(recipeType);
    }

    private void registerRecipeManager(Class<? extends IRecipeManager> managerClass) {
        if (managerInstances.containsKey(managerClass)) {
            IRecipeManager manager = managerInstances.get(managerClass);
            this.registerInstance(manager);
            return;
        }
        IRecipeManager manager = InstantiationUtil.getOrCreateInstance(managerClass);
        if (manager == null) {
            CraftTweakerAPI.logError("Could not add RecipeManager for %s, please report to the author", managerClass);
            return;
        }
        managerInstances.put(managerClass, manager);
        this.registerInstance(manager);
    }

    private void registerInstance(IRecipeManager manager) {
        ResourceLocation bracketResourceLocation = manager.getBracketResourceLocation();
        Class<?> managerClass = manager.getClass();
        if (managerClass.getAnnotation(ZenCodeType.Name.class) == null) {
            String canonicalName = managerClass.getCanonicalName();
            CraftTweakerAPI.logWarning("No Name Annotation found on manager '%s', it will not be registered!", canonicalName);
            return;
        }
        registeredTypes.put(RecipeTypeBracketHandler.lookup(bracketResourceLocation), manager);
    }

    @Override
    public ParsedExpression parse(CodePosition position, ZSTokenParser tokens) throws ParseException {
        String name = ParseUtil.readContent(tokens);
        ResourceLocation resourceLocation = ResourceLocation.func_208304_a((String)name);
        if (resourceLocation == null) {
            throw new ParseException(position, "Invalid ResourceLocation, expected: <recipetype:modid:location>");
        }
        if (registeredTypes.containsKey(RecipeTypeBracketHandler.lookup(resourceLocation))) {
            return this.getCall(name, registeredTypes.get(RecipeTypeBracketHandler.lookup(resourceLocation)), position);
        }
        if (Registry.field_218367_H.func_148742_b().contains(resourceLocation)) {
            return this.getCallFallback(name, position);
        }
        throw new ParseException(position, String.format("Unknown RecipeType: <recipetype:%s>", name));
    }

    private ParsedExpression getCallFallback(String location, CodePosition position) {
        ParsedExpressionVariable crafttweaker = new ParsedExpressionVariable(position, "crafttweaker", null);
        ParsedExpressionMember api = new ParsedExpressionMember(position, crafttweaker, "api", Collections.emptyList());
        ParsedExpressionMember bracketHandlers = new ParsedExpressionMember(position, api, "BracketHandlers", null);
        ParsedExpressionMember getRecipeManager = new ParsedExpressionMember(position, bracketHandlers, "getRecipeManager", null);
        return new ParsedExpressionCall(position, getRecipeManager, new ParsedCallArguments(Collections.emptyList(), Collections.singletonList(new ParsedExpressionString(position, location, false))));
    }

    private ParsedExpression getCall(String location, IRecipeManager manager, CodePosition position) {
        ParsedExpressionVariable crafttweaker = new ParsedExpressionVariable(position, "crafttweaker", null);
        ParsedExpressionMember api = new ParsedExpressionMember(position, crafttweaker, "api", Collections.emptyList());
        ParsedExpressionMember recipeTypeBracketHandler = new ParsedExpressionMember(position, api, "RecipeTypeBracketHandler", null);
        ParsedExpressionMember getRecipeManager = new ParsedExpressionMember(position, recipeTypeBracketHandler, "getRecipeManager", null);
        String nameContent = manager.getClass().getAnnotation(ZenCodeType.Name.class).value();
        IParsedType parsedType = ParseUtil.readParsedType(nameContent, position);
        ParsedCallArguments arguments = new ParsedCallArguments(Collections.singletonList(parsedType), Collections.singletonList(new ParsedExpressionString(position, location, false)));
        ParsedExpressionCall parsedExpressionCall = new ParsedExpressionCall(position, getRecipeManager, arguments);
        return new ParsedExpressionCast(position, parsedExpressionCall, parsedType, false);
    }

    private static IRecipeType<?> lookup(ResourceLocation location) {
        return (IRecipeType)Registry.field_218367_H.func_82594_a(location);
    }
}

