/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.impl.commands.CTCommands;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class BracketDumperInfo
implements CTCommands.CommandCallerPlayer {
    private final String bepHandlerName;
    private final String dumpedFileName;
    private final String subCommandName;
    private final List<MethodHandle> methodHandles = new ArrayList<MethodHandle>(1);

    public BracketDumperInfo(String bepHandlerName, String subCommandName, String dumpedFileName) {
        this.bepHandlerName = bepHandlerName;
        this.subCommandName = subCommandName.isEmpty() ? BracketDumperInfo.makePlural(bepHandlerName) : subCommandName;
        this.dumpedFileName = dumpedFileName.isEmpty() ? bepHandlerName.toLowerCase() : dumpedFileName;
    }

    private static String makePlural(String s) {
        if (s.endsWith("s")) {
            return s;
        }
        if (s.endsWith("x")) {
            return s;
        }
        return s + "s";
    }

    public void addMethodHandle(MethodHandle methodHandle) {
        this.methodHandles.add(methodHandle);
    }

    public String getSubCommandName() {
        return this.subCommandName;
    }

    public String getDescription() {
        return String.format("Outputs a list of all known '%s' BEPs", this.bepHandlerName);
    }

    public String getDumpedFileName() {
        return this.dumpedFileName;
    }

    public Stream<String> getDumpedValuesStream() {
        return this.methodHandles.stream().flatMap(methodHandle -> {
            try {
                Collection invoke = methodHandle.invokeExact();
                return invoke.stream();
            }
            catch (Throwable throwable) {
                CraftTweakerAPI.logThrowing("Error executing Bracket dumper '%s'", throwable, this.bepHandlerName);
                return Stream.empty();
            }
        });
    }

    @Override
    public int executeCommand(PlayerEntity player, ItemStack stack) {
        this.getDumpedValuesStream().forEach(bepCall -> CraftTweakerAPI.logDump("- " + bepCall, new Object[0]));
        String message = String.format("List of '%s' BEPs generated! Check the crafttweaker.log file!", this.bepHandlerName);
        CTCommands.send((ITextComponent)new StringTextComponent(CTCommands.color(message, TextFormatting.GREEN)), player);
        return 0;
    }
}

