/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands;

import com.blamejared.crafttweaker.CraftTweaker;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.text.FormattedTextComponent;
import com.blamejared.crafttweaker.impl.network.PacketHandler;
import com.blamejared.crafttweaker.impl.network.messages.MessageCopy;
import java.io.File;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public final class CommandUtilities {
    private CommandUtilities() {
    }

    public static void sendCopyingAndCopy(TextComponent component, String toCopy, PlayerEntity player) {
        CommandUtilities.sendCopying(component, toCopy, player);
        CommandUtilities.copy(player, toCopy);
    }

    public static void sendCopying(TextComponent component, String toCopy, PlayerEntity player) {
        CommandUtilities.send(CommandUtilities.copy(component, toCopy), player);
    }

    public static void send(ITextComponent component, CommandSource source) {
        source.func_197030_a(component, true);
        CraftTweakerAPI.logDump(component.getString(), new Object[0]);
    }

    public static void send(ITextComponent component, PlayerEntity player) {
        player.func_145747_a(component, CraftTweaker.CRAFTTWEAKER_UUID);
        CraftTweakerAPI.logDump(component.func_150261_e(), new Object[0]);
    }

    @Deprecated
    public static void send(String string, PlayerEntity player) {
        CommandUtilities.send((ITextComponent)new StringTextComponent(string), player);
    }

    public static void copy(PlayerEntity player, String toCopy) {
        if (player instanceof ServerPlayerEntity) {
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageCopy(toCopy));
        }
    }

    public static void open(PlayerEntity player, File file) {
        String link = file.getPath();
        CommandUtilities.send(CommandUtilities.openingUrl(new TranslationTextComponent("Click to open: %s", new Object[]{CommandUtilities.makeNoticeable(link)}).func_240699_a_(TextFormatting.GREEN), link), player);
    }

    @Deprecated
    public static String color(String str, TextFormatting formatting) {
        return formatting + str + TextFormatting.RESET;
    }

    public static String stripNewLine(String string) {
        return string.substring(0, string.lastIndexOf("\n"));
    }

    public static String stripNewLine(StringBuilder string) {
        return string.substring(0, string.lastIndexOf("\n"));
    }

    public static ITextComponent copy(TextComponent base, String toCopy) {
        Style style = base.func_150256_b();
        style = style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new FormattedTextComponent("Click to copy [%s]", CommandUtilities.color(toCopy, TextFormatting.GOLD))));
        style = style.func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, toCopy));
        return base.func_230530_a_(style);
    }

    public static ITextComponent open(TextComponent base, String path) {
        Style style = base.func_150256_b();
        style = style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new FormattedTextComponent("Click to open [%s]", CommandUtilities.color(path, TextFormatting.GOLD))));
        style = style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, path));
        return base.func_230530_a_(style);
    }

    public static TextComponent run(TextComponent base, String command) {
        Style style = Style.field_240709_b_;
        style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new FormattedTextComponent("Click to run [%s]", CommandUtilities.color(command, TextFormatting.GOLD))));
        style.func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command));
        base.func_230530_a_(style);
        return base;
    }

    public static ITextComponent openingUrl(IFormattableTextComponent base, String url) {
        StringTextComponent component = new StringTextComponent(String.format("Click to go to [%s]", url));
        return base.func_240700_a_(arg_0 -> CommandUtilities.lambda$openingUrl$1((IFormattableTextComponent)component, url, arg_0));
    }

    public static IFormattableTextComponent makeNoticeable(IFormattableTextComponent text) {
        return text.func_240699_a_(TextFormatting.YELLOW);
    }

    public static IFormattableTextComponent makeNoticeable(String text) {
        return CommandUtilities.makeNoticeable((IFormattableTextComponent)new StringTextComponent(text));
    }

    private static /* synthetic */ Style lambda$openingUrl$1(IFormattableTextComponent component, String url, Style style) {
        return style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)component)).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
    }
}

