/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands.script_examples;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.UnknownServiceException;
import javax.annotation.Nullable;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.shared.SourceFile;

public class ClassPathSourceFile
implements SourceFile {
    private final ResourceLocation location;
    private final IResourceManager resourceManager;

    private ClassPathSourceFile(ResourceLocation location, IResourceManager resourceManager) {
        this.location = location;
        this.resourceManager = resourceManager;
    }

    @Nullable
    public static ClassPathSourceFile fromLocation(ResourceLocation location, IResourceManager resourceManager) {
        if (!resourceManager.func_219533_b(ClassPathSourceFile.addPrefixAndSuffix(location))) {
            CraftTweakerAPI.logError("Unknown script name: " + location, new Object[0]);
            return null;
        }
        return new ClassPathSourceFile(location, resourceManager);
    }

    private static ResourceLocation addPrefixAndSuffix(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), "scripts/" + location.func_110623_a() + ".zs");
    }

    @Override
    public String getFilename() {
        return this.location.func_110623_a() + ".zs";
    }

    @Override
    public Reader open() throws IOException {
        IResource resource = this.resourceManager.func_199002_a(ClassPathSourceFile.addPrefixAndSuffix(this.location));
        return new InputStreamReader(resource.func_199027_b());
    }

    @Override
    public void update(String content) throws IOException {
        throw new UnknownServiceException("Cannot write to a ClassPathSourceFile");
    }
}

