/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot.conditions.vanilla;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.loot.conditions.ILootCondition;
import com.blamejared.crafttweaker.impl.loot.conditions.ILootConditionTypeBuilder;
import com.blamejared.crafttweaker.impl.predicate.TargetedEntity;
import com.blamejared.crafttweaker.impl_native.loot.ExpandLootContext;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.function.Consumer;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.loot.conditions.vanilla.EntityProperties")
@Document(value="vanilla/api/loot/conditions/vanilla/EntityProperties")
public final class EntityPropertiesLootConditionTypeBuilder
implements ILootConditionTypeBuilder {
    private TargetedEntity targetedEntity;
    private com.blamejared.crafttweaker.impl.predicate.EntityPredicate predicate = new com.blamejared.crafttweaker.impl.predicate.EntityPredicate();

    EntityPropertiesLootConditionTypeBuilder() {
    }

    @ZenCodeType.Method
    public EntityPropertiesLootConditionTypeBuilder withTargetedEntity(TargetedEntity entity) {
        this.targetedEntity = entity;
        return this;
    }

    @ZenCodeType.Method
    public EntityPropertiesLootConditionTypeBuilder withPredicate(Consumer<com.blamejared.crafttweaker.impl.predicate.EntityPredicate> builder) {
        com.blamejared.crafttweaker.impl.predicate.EntityPredicate predicate = new com.blamejared.crafttweaker.impl.predicate.EntityPredicate();
        builder.accept(predicate);
        this.predicate = predicate;
        return this;
    }

    @Override
    public ILootCondition finish() {
        if (this.targetedEntity == null) {
            throw new IllegalStateException("Targeted entity not defined for an 'EntityProperties' condition");
        }
        EntityPredicate vanilla = (EntityPredicate)this.predicate.toVanillaPredicate();
        return context -> {
            Entity entity = this.targetedEntity.getLootContextDiscriminator().apply(context);
            Vector3d origin = ExpandLootContext.getOrigin(context);
            ServerWorld world = ExpandLootContext.getWorld(context);
            return world instanceof ServerWorld && vanilla.func_217993_a(world, origin, entity);
        };
    }
}

