/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.native_types;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.openzen.zencode.java.ZenCodeType;

public class CrTNativeExecutableRef {
    private final Class<?>[] arguments;
    private final Map<Class<? extends Annotation>, Annotation> presentAnnotationTypes = new HashMap<Class<? extends Annotation>, Annotation>();

    CrTNativeExecutableRef(Class<?>[] arguments) {
        this.arguments = arguments;
    }

    <T extends Annotation> void withAnnotation(T annotation) {
        this.presentAnnotationTypes.put(annotation.annotationType(), annotation);
    }

    void withMethodAnnotation() {
        this.withAnnotation(this.createMethodAnnotation());
    }

    CrTNativeExecutableRef withGetter(String getterName) {
        if (!getterName.isEmpty()) {
            this.withAnnotation(this.createGetterAnnotation(getterName));
        }
        return this;
    }

    CrTNativeExecutableRef withSetter(String setterName) {
        if (!setterName.isEmpty()) {
            this.withAnnotation(this.createSetterAnnotation(setterName));
        }
        return this;
    }

    void withConstructorAnnotation() {
        this.withAnnotation(this.createConstructorAnnotation());
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationClass) {
        return Optional.ofNullable(this.presentAnnotationTypes.getOrDefault(annotationClass, null));
    }

    boolean matchesParameters(Class<?>[] parameters) {
        return Arrays.equals(this.arguments, parameters);
    }

    private ZenCodeType.Method createMethodAnnotation() {
        return new ZenCodeType.Method(){

            @Override
            public String value() {
                return "";
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return ZenCodeType.Method.class;
            }
        };
    }

    private ZenCodeType.Constructor createConstructorAnnotation() {
        return new ZenCodeType.Constructor(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return ZenCodeType.Constructor.class;
            }
        };
    }

    private ZenCodeType.Getter createGetterAnnotation(final String setterName) {
        return new ZenCodeType.Getter(){

            @Override
            public String value() {
                return setterName;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return ZenCodeType.Getter.class;
            }
        };
    }

    private ZenCodeType.Setter createSetterAnnotation(final String setterName) {
        return new ZenCodeType.Setter(){

            @Override
            public String value() {
                return setterName;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return ZenCodeType.Setter.class;
            }
        };
    }
}

