/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.predicate;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.predicate.FloatRangePredicate;
import com.blamejared.crafttweaker.impl.predicate.IVanillaWrappingPredicate;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.stream.Stream;
import net.minecraft.advancements.criterion.MinMaxBounds;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.predicate.DistancePredicate")
@Document(value="vanilla/api/predicate/DistancePredicate")
public final class DistancePredicate
extends IVanillaWrappingPredicate.AnyDefaulting<net.minecraft.advancements.criterion.DistancePredicate> {
    private FloatRangePredicate absoluteDistance = FloatRangePredicate.unbounded();
    private FloatRangePredicate horizontalDistance = FloatRangePredicate.unbounded();
    private FloatRangePredicate xDistance = FloatRangePredicate.unbounded();
    private FloatRangePredicate yDistance = FloatRangePredicate.unbounded();
    private FloatRangePredicate zDistance = FloatRangePredicate.unbounded();

    public DistancePredicate() {
        super(net.minecraft.advancements.criterion.DistancePredicate.field_193423_a);
    }

    @ZenCodeType.Method
    public DistancePredicate withMinimumAbsoluteDistance(float min) {
        this.absoluteDistance = FloatRangePredicate.mergeLowerBound(this.absoluteDistance, min);
        return this;
    }

    @ZenCodeType.Method
    public DistancePredicate withMaximumAbsoluteDistance(float max) {
        this.absoluteDistance = FloatRangePredicate.mergeUpperBound(this.absoluteDistance, max);
        return this;
    }

    @ZenCodeType.Method
    public DistancePredicate withRangedAbsoluteDistance(float min, float max) {
        this.absoluteDistance = FloatRangePredicate.bounded(min, max);
        return this;
    }

    @ZenCodeType.Method
    public DistancePredicate withMinimumHorizontalDistance(float min) {
        this.horizontalDistance = FloatRangePredicate.mergeLowerBound(this.horizontalDistance, min);
        return this;
    }

    @ZenCodeType.Method
    public DistancePredicate withMaximumHorizontalDistance(float max) {
        this.horizontalDistance = FloatRangePredicate.mergeUpperBound(this.horizontalDistance, max);
        return this;
    }

    @ZenCodeType.Method
    public DistancePredicate withRangedHorizontalDistance(float min, float max) {
        this.horizontalDistance = FloatRangePredicate.bounded(min, max);
        return this;
    }

    @ZenCodeType.Method
    public DistancePredicate withMinimumX(float min) {
        this.xDistance = FloatRangePredicate.mergeLowerBound(this.xDistance, min);
        return this;
    }

    @ZenCodeType.Method
    public DistancePredicate withMaximumX(float max) {
        this.xDistance = FloatRangePredicate.mergeUpperBound(this.xDistance, max);
        return this;
    }

    @ZenCodeType.Method
    public DistancePredicate withRangedX(float min, float max) {
        this.xDistance = FloatRangePredicate.bounded(min, max);
        return this;
    }

    @ZenCodeType.Method
    public DistancePredicate withMinimumY(float min) {
        this.yDistance = FloatRangePredicate.mergeLowerBound(this.yDistance, min);
        return this;
    }

    @ZenCodeType.Method
    public DistancePredicate withMaximumY(float max) {
        this.yDistance = FloatRangePredicate.mergeUpperBound(this.yDistance, max);
        return this;
    }

    @ZenCodeType.Method
    public DistancePredicate withRangedY(float min, float max) {
        this.yDistance = FloatRangePredicate.bounded(min, max);
        return this;
    }

    @ZenCodeType.Method
    public DistancePredicate withMinimumZ(float min) {
        this.zDistance = FloatRangePredicate.mergeLowerBound(this.zDistance, min);
        return this;
    }

    @ZenCodeType.Method
    public DistancePredicate withMaximumZ(float max) {
        this.zDistance = FloatRangePredicate.mergeUpperBound(this.zDistance, max);
        return this;
    }

    @ZenCodeType.Method
    public DistancePredicate withRangedZ(float min, float max) {
        this.zDistance = FloatRangePredicate.bounded(min, max);
        return this;
    }

    @Override
    public boolean isAny() {
        return Stream.of(this.absoluteDistance, this.horizontalDistance, this.xDistance, this.yDistance, this.zDistance).allMatch(FloatRangePredicate::isAny);
    }

    @Override
    public net.minecraft.advancements.criterion.DistancePredicate toVanilla() {
        return new net.minecraft.advancements.criterion.DistancePredicate((MinMaxBounds.FloatBound)this.xDistance.toVanillaPredicate(), (MinMaxBounds.FloatBound)this.yDistance.toVanillaPredicate(), (MinMaxBounds.FloatBound)this.zDistance.toVanillaPredicate(), (MinMaxBounds.FloatBound)this.horizontalDistance.toVanillaPredicate(), (MinMaxBounds.FloatBound)this.absoluteDistance.toVanillaPredicate());
    }
}

