/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.predicate;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.predicate.IVanillaWrappingPredicate;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Objects;
import net.minecraft.advancements.criterion.MinMaxBounds;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.predicate.FloatRangePredicate")
@Document(value="vanilla/api/predicate/FloatRangePredicate")
public final class FloatRangePredicate
extends IVanillaWrappingPredicate.AnyDefaulting<MinMaxBounds.FloatBound> {
    private static final FloatRangePredicate UNBOUNDED = new FloatRangePredicate(-3.4028235E38f, Float.MAX_VALUE);
    private final float min;
    private final float max;

    private FloatRangePredicate(float min, float max) {
        super(MinMaxBounds.FloatBound.field_211359_e);
        this.min = min;
        this.max = max;
    }

    public static FloatRangePredicate unbounded() {
        return UNBOUNDED;
    }

    public static FloatRangePredicate lowerBounded(float min) {
        return new FloatRangePredicate(min, Float.MAX_VALUE);
    }

    public static FloatRangePredicate upperBounded(float max) {
        return new FloatRangePredicate(-3.4028235E38f, max);
    }

    public static FloatRangePredicate bounded(float min, float max) {
        if (min > max) {
            throw new IllegalArgumentException("Minimum FloatRange bound must not be more than maximum bound");
        }
        return new FloatRangePredicate(min, max);
    }

    public static FloatRangePredicate mergeLowerBound(FloatRangePredicate previous, float min) {
        if (previous == null) {
            return FloatRangePredicate.lowerBounded(min);
        }
        return FloatRangePredicate.bounded(min, previous.getMax());
    }

    public static FloatRangePredicate mergeUpperBound(FloatRangePredicate previous, float max) {
        if (previous == null) {
            return FloatRangePredicate.upperBounded(max);
        }
        return FloatRangePredicate.bounded(previous.getMin(), max);
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public boolean match(int target) {
        return this.min <= (float)target && (float)target <= this.max;
    }

    @Override
    public boolean isAny() {
        return this.equals(UNBOUNDED);
    }

    @Override
    public MinMaxBounds.FloatBound toVanilla() {
        return new MinMaxBounds.FloatBound(Float.valueOf(this.min), Float.valueOf(this.max));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatRangePredicate that = (FloatRangePredicate)o;
        return Float.compare(that.getMin(), this.getMin()) == 0 && Float.compare(that.getMax(), this.getMax()) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.getMin()), Float.valueOf(this.getMax()));
    }

    public String toString() {
        return this.getMin() + ".." + this.getMax();
    }
}

