/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes.handlers.vanilla;

import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.api.recipes.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.util.StringUtils;
import com.blamejared.crafttweaker.impl.helper.ItemStackHelper;
import com.blamejared.crafttweaker.impl.recipes.helper.CraftingTableRecipeConflictChecker;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.ResourceLocation;

@IRecipeHandler.For(value=ShapelessRecipe.class)
public final class ShapelessRecipeHandler
implements IRecipeHandler<ShapelessRecipe> {
    @Override
    public String dumpToCommandString(IRecipeManager manager, ShapelessRecipe recipe) {
        return String.format("craftingTable.addShapeless(%s, %s, %s);", StringUtils.quoteAndEscape(recipe.func_199560_c()), ItemStackHelper.getCommandString(recipe.func_77571_b()), recipe.func_192400_c().stream().map(IIngredient::fromIngredient).map(IIngredient::getCommandString).collect(Collectors.joining(", ", "[", "]")));
    }

    @Override
    public Optional<Function<ResourceLocation, ShapelessRecipe>> replaceIngredients(IRecipeManager manager, ShapelessRecipe recipe, List<IReplacementRule> rules) {
        return ReplacementHandlerHelper.replaceNonNullIngredientList(recipe.func_192400_c(), Ingredient.class, recipe, rules, newIngredients -> id -> new ShapelessRecipe(id, recipe.func_193358_e(), recipe.func_77571_b(), newIngredients));
    }

    @Override
    public <U extends IRecipe<?>> boolean doesConflict(IRecipeManager manager, ShapelessRecipe firstRecipe, U secondRecipe) {
        return CraftingTableRecipeConflictChecker.checkConflicts(manager, firstRecipe, secondRecipe);
    }
}

