/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes.handlers.vanilla;

import com.blamejared.crafttweaker.api.CraftTweakerRegistry;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.api.util.StringUtils;
import com.blamejared.crafttweaker.impl.helper.IngredientHelper;
import com.blamejared.crafttweaker.impl.helper.ItemStackHelper;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SmithingRecipe;
import net.minecraft.util.ResourceLocation;

@IRecipeHandler.For(value=SmithingRecipe.class)
public final class SmithingRecipeHandler
implements IRecipeHandler<SmithingRecipe> {
    @Override
    public String dumpToCommandString(IRecipeManager manager, SmithingRecipe recipe) {
        return String.format("smithing.addRecipe(%s, %s, %s, %s);", StringUtils.quoteAndEscape(recipe.func_199560_c()), ItemStackHelper.getCommandString(recipe.func_77571_b()), IIngredient.fromIngredient(recipe.field_234837_a_).getCommandString(), IIngredient.fromIngredient(recipe.field_234838_b_).getCommandString());
    }

    @Override
    public Optional<Function<ResourceLocation, SmithingRecipe>> replaceIngredients(IRecipeManager manager, SmithingRecipe recipe, List<IReplacementRule> rules) {
        Optional<Ingredient> base = IRecipeHandler.attemptReplacing(recipe.field_234837_a_, Ingredient.class, recipe, rules);
        Optional<Ingredient> addition = IRecipeHandler.attemptReplacing(recipe.field_234838_b_, Ingredient.class, recipe, rules);
        if (!base.isPresent() && !addition.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(id -> new SmithingRecipe(id, base.orElseGet(() -> recipe.field_234837_a_), addition.orElseGet(() -> recipe.field_234838_b_), recipe.func_77571_b()));
    }

    @Override
    public <U extends IRecipe<?>> boolean doesConflict(IRecipeManager manager, SmithingRecipe firstRecipe, U secondRecipe) {
        if (!(secondRecipe instanceof SmithingRecipe)) {
            return this.redirectNonVanilla(manager, secondRecipe, firstRecipe);
        }
        SmithingRecipe second = (SmithingRecipe)secondRecipe;
        return IngredientHelper.canConflict(firstRecipe.field_234837_a_, second.field_234837_a_) && IngredientHelper.canConflict(firstRecipe.field_234838_b_, second.field_234838_b_);
    }

    private <T extends IRecipe<?>> boolean redirectNonVanilla(IRecipeManager manager, T second, SmithingRecipe first) {
        return CraftTweakerRegistry.getHandlerFor(second).doesConflict(manager, second, first);
    }
}

