/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes.helper;

import com.blamejared.crafttweaker.api.CraftTweakerRegistry;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.helper.IngredientHelper;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.IShapedRecipe;

public final class CraftingTableRecipeConflictChecker {
    public static boolean checkConflicts(IRecipeManager manager, IRecipe<?> first, IRecipe<?> second) {
        if (first.func_192399_d() || second.func_192399_d()) {
            return false;
        }
        if (!(first instanceof IShapedRecipe) && second instanceof IShapedRecipe) {
            return CraftingTableRecipeConflictChecker.redirect(manager, second, first);
        }
        return CraftingTableRecipeConflictChecker.checkConflictsMaybeDifferent(first, second);
    }

    private static <T extends IRecipe<?>> boolean redirect(IRecipeManager manager, T second, IRecipe<?> first) {
        return CraftTweakerRegistry.getHandlerFor(second).doesConflict(manager, second, first);
    }

    private static boolean checkConflictsMaybeDifferent(IRecipe<?> first, IRecipe<?> second) {
        if (first instanceof IShapedRecipe) {
            if (second instanceof IShapedRecipe) {
                return CraftingTableRecipeConflictChecker.doShapedShapedConflict((IShapedRecipe)first, (IShapedRecipe)second);
            }
            return CraftingTableRecipeConflictChecker.doShapedShapelessConflict((IShapedRecipe)first, second);
        }
        return CraftingTableRecipeConflictChecker.doShapelessShapelessConflict(first, second);
    }

    private static boolean doShapedShapedConflict(IShapedRecipe<?> first, IShapedRecipe<?> second) {
        if (first.getRecipeHeight() != second.getRecipeHeight()) {
            return false;
        }
        if (first.getRecipeWidth() != second.getRecipeWidth()) {
            return false;
        }
        NonNullList firstIngredients = first.func_192400_c();
        NonNullList secondIngredients = second.func_192400_c();
        for (int i = 0; i < firstIngredients.size(); ++i) {
            Ingredient secondIngredient;
            Ingredient firstIngredient = (Ingredient)firstIngredients.get(i);
            if (IngredientHelper.canConflict(firstIngredient, secondIngredient = (Ingredient)secondIngredients.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean doShapedShapelessConflict(IShapedRecipe<?> first, IRecipe<?> second) {
        return CraftingTableRecipeConflictChecker.doShapelessShapelessConflict(first.func_192400_c().stream().filter(it -> it != Ingredient.field_193370_a).collect(Collectors.toList()), (List<Ingredient>)second.func_192400_c());
    }

    private static boolean doShapelessShapelessConflict(IRecipe<?> first, IRecipe<?> second) {
        return CraftingTableRecipeConflictChecker.doShapelessShapelessConflict((List<Ingredient>)first.func_192400_c(), (List<Ingredient>)second.func_192400_c());
    }

    private static boolean doShapelessShapelessConflict(List<Ingredient> first, List<Ingredient> second) {
        if (first.size() != second.size()) {
            return false;
        }
        return CraftingTableRecipeConflictChecker.craftShapelessRecipeVirtually(first, second);
    }

    private static boolean craftShapelessRecipeVirtually(List<Ingredient> first, List<Ingredient> second) {
        BitSet visitData = new BitSet(second.size());
        block0: for (Ingredient target : first) {
            for (int j = 0; j < second.size(); ++j) {
                Ingredient attempt;
                if (visitData.get(j) || !IngredientHelper.canConflict(target, attempt = second.get(j))) continue;
                visitData.set(j);
                continue block0;
            }
        }
        return visitData.nextClearBit(0) == second.size();
    }
}

