/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes.replacement;

import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;

public final class FullIngredientReplacementRule
implements IReplacementRule {
    private final IIngredient from;
    private final IIngredient to;

    private FullIngredientReplacementRule(IIngredient from, IIngredient to) {
        this.from = from;
        this.to = to;
    }

    public static IReplacementRule create(IIngredient from, IIngredient to) {
        return FullIngredientReplacementRule.areTheSame(from, to) ? IReplacementRule.EMPTY : new FullIngredientReplacementRule(from, to);
    }

    private static boolean areTheSame(IIngredient a, IIngredient b) {
        return a == b || Objects.equals(a, b) || a.contains(b) && b.contains(a);
    }

    @Override
    public <T, U extends IRecipe<?>> Optional<T> getReplacement(T ingredient, Class<T> type, U recipe) {
        return IReplacementRule.chain(IReplacementRule.withType(ingredient, type, recipe, IIngredient.class, this::getIIngredientReplacement), IReplacementRule.withType(ingredient, type, recipe, Ingredient.class, this::getIngredientReplacement));
    }

    private <U extends IRecipe<?>> Optional<IIngredient> getIIngredientReplacement(IIngredient ingredient, U recipe) {
        return FullIngredientReplacementRule.areTheSame(this.from, ingredient) ? Optional.of(this.to) : Optional.empty();
    }

    private <U extends IRecipe<?>> Optional<Ingredient> getIngredientReplacement(Ingredient ingredient, U recipe) {
        return this.getIIngredientReplacement(IIngredient.fromIngredient(ingredient), recipe).map(IIngredient::asVanillaIngredient);
    }

    @Override
    public String describe() {
        return String.format("Replacing fully %s --> %s", this.from.getCommandString(), this.to.getCommandString());
    }
}

