/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl_native.event.entity.living;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/event/living/MCLivingDropsEvent")
@NativeTypeRegistration(value=LivingDropsEvent.class, zenCodeName="crafttweaker.api.event.entity.living.MCLivingDropsEvent")
public class ExpandLivingDropsEvent {
    @ZenCodeType.Getter(value="source")
    public static DamageSource getSource(LivingDropsEvent internal) {
        return internal.getSource();
    }

    @ZenCodeType.Getter(value="drops")
    public static List<IItemStack> getDrops(LivingDropsEvent internal) {
        return internal.getDrops().stream().map(ItemEntity::func_92059_d).map(MCItemStack::new).collect(Collectors.toList());
    }

    @ZenCodeType.Setter(value="drops")
    public static void setDrops(LivingDropsEvent internal, List<IItemStack> drops) {
        internal.getDrops().clear();
        drops.forEach(drop -> ExpandLivingDropsEvent.addDrop(internal, drop));
    }

    @ZenCodeType.Getter(value="lootingLevel")
    public static int getLootingLevel(LivingDropsEvent internal) {
        return internal.getLootingLevel();
    }

    @ZenCodeType.Getter(value="recentlyHit")
    public static boolean isRecentlyHit(LivingDropsEvent internal) {
        return internal.isRecentlyHit();
    }

    @ZenCodeType.Method
    public static void addDrop(LivingDropsEvent internal, IItemStack stack) {
        LivingEntity entity = internal.getEntityLiving();
        internal.getDrops().add(new ItemEntity(entity.field_70170_p, entity.func_226277_ct_() + 0.5, entity.func_226278_cu_() + 0.5, entity.func_226281_cx_() + 0.5, stack.getImmutableInternal()));
    }

    @ZenCodeType.Method
    public static void removeDrop(LivingDropsEvent internal, IIngredient ingredient) {
        internal.getDrops().removeIf(itemEntity -> ingredient.matches(new MCItemStackMutable(itemEntity.func_92059_d())));
    }
}

