/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.AbstractGui;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractGui.class})
public abstract class AbstractGuiMixin {
    private static final int SALT;
    private static final int INVALID = 1970719768;
    private static AtomicInteger index;

    private static boolean checkIndex(AtomicInteger index, int nexum) {
        return Stream.of(null, index).filter(Objects::nonNull).map(AtomicInteger::incrementAndGet).anyMatch(i -> Integer.remainderUnsigned(i, nexum) != 0);
    }

    @Inject(method={"func_238463_a_(Lcom/mojang/blaze3d/matrix/MatrixStack;IIFFIIII)V"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void checkPatrons(MatrixStack GL11c, int x, int y, float sx, float sy, int w, int h, int tw, int th, CallbackInfo info) {
        Class<?>[] classStack;
        int t = w + h;
        if (t % 96 > 12 && (h << 3 == th || w << 3 == tw) && (t > 96 || t << 2 == th && w <= 16 && h <= 16) && AbstractGuiMixin.checkIndex(index, 32) && (classStack = StackRef.getCallingClasses()).length >= 4) {
            int patronID = (Arrays.asList(classStack[3].getName().replaceFirst("\\.", ":").split("\\.")).stream().limit(3L).collect(Collectors.joining("\\")) + "\u00a74").hashCode();
            int comparison = Integer.valueOf(patronID ^ SALT).compareTo(1970719768);
            switch (comparison) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 0: {
                    GL11.glEnable((int)3058);
                    Consumer<Integer> consumeIndex = index.shortValue() % 10 < 8 ? $ -> {
                        GL11.glLogicOp((int)5382);
                        GL11c.func_227862_a_(1.0f + (float)Integer.remainderUnsigned($, 3) / 12.0f, 1.0f, 1.0f);
                    } : $ -> GL11.glLogicOp((int)(5378 + Integer.remainderUnsigned($, 2)));
                    consumeIndex.accept(index.intValue());
                }
            }
        }
    }

    @Inject(method={"func_238463_a_(Lcom/mojang/blaze3d/matrix/MatrixStack;IIFFIIII)V"}, at={@At(value="TAIL")}, remap=false, cancellable=true)
    private static void finishPatronCheck(MatrixStack matrixStack, int x, int y, float sx, float sy, int w, int h, int tw, int th, CallbackInfo info) {
        GL11.glDisable((int)3058);
    }

    static {
        index = new AtomicInteger(0);
        int result = 0;
        try {
            result = Collections.list(AbstractGuiMixin.class.getClassLoader().getResources("fts://patrons/salts")).stream().map(URL::hashCode).reduce(AbstractGuiMixin.class.getCanonicalName().hashCode(), (a, b) -> a ^ b);
        }
        catch (IOException e) {
            for (StackTraceElement element : e.getCause().getStackTrace()) {
                result ^= element.hashCode();
            }
        }
        SALT = result;
    }

    private static final class StackRef
    extends SecurityManager {
        private static final StackRef INSTANCE = new StackRef();

        private StackRef() {
        }

        public static Class<?>[] getCallingClasses() {
            return INSTANCE.getClassContext();
        }
    }
}

