/*
 * Decompiled with CFR 0.152.
 */
package coffee.injected.improvedbackpacks.backpack;

import coffee.injected.improvedbackpacks.ImprovedBackpacks;
import coffee.injected.improvedbackpacks.backpack.BackpackManager;
import coffee.injected.improvedbackpacks.backpack.access.KeybindBackpackAccessor;
import coffee.injected.improvedbackpacks.backpack.data.BackpackData;
import coffee.injected.improvedbackpacks.backpack.data.BackpackDataKt;
import coffee.injected.improvedbackpacks.backpack.giver.EntityBackpackGiver;
import coffee.injected.improvedbackpacks.backpack.slot.BackpackSlot;
import coffee.injected.improvedbackpacks.capability.mob.BackpackOwner;
import coffee.injected.improvedbackpacks.capability.mob.BackpackOwnerKt;
import coffee.injected.improvedbackpacks.capability.player.BackpackUser;
import coffee.injected.improvedbackpacks.capability.player.BackpackUserKt;
import coffee.injected.improvedbackpacks.capability.player.ServerBackpackUser;
import coffee.injected.improvedbackpacks.registry.IBConfig;
import coffee.injected.improvedbackpacks.registry.IBCriteriaTriggers;
import coffee.injected.improvedbackpacks.util.AccessUtilsKt;
import coffee.injected.improvedbackpacks.util.RegistryCollection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.UUID;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001(B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0006J*\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u001a\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00020\u0014\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00150\u0013J&\u0010\u0017\u001a\n\u0012\u0004\u0012\u0002H\u0018\u0018\u00010\u0006\"\b\b\u0000\u0010\u0018*\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0005J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001c\u001a\u00020\u0014J\u0006\u0010\u001d\u001a\u00020\rJ\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0016J\u001e\u0010#\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'R\"\u0010\u0003\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u001c\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcoffee/injected/improvedbackpacks/backpack/BackpackManager;", "", "()V", "backpackGivers", "", "Lnet/minecraft/entity/EntityType;", "Lcoffee/injected/improvedbackpacks/backpack/giver/EntityBackpackGiver;", "keybindAccessors", "Lcoffee/injected/improvedbackpacks/util/RegistryCollection;", "Lcoffee/injected/improvedbackpacks/backpack/access/KeybindBackpackAccessor;", "kotlin.jvm.PlatformType", "Ljava/util/PriorityQueue;", "addBackpackGiver", "", "giver", "addKeybindAccessor", "priority", "", "slot", "Lkotlin/Function1;", "Lnet/minecraft/entity/player/ServerPlayerEntity;", "Ljava/util/Optional;", "Lcoffee/injected/improvedbackpacks/backpack/slot/BackpackSlot;", "getBackpackGiver", "T", "Lnet/minecraft/entity/Entity;", "entityType", "getBackpackSlotByKeybind", "player", "setup", "setupEnd", "event", "Lnet/minecraftforge/fml/event/lifecycle/FMLLoadCompleteEvent;", "tryOpenBackpack", "", "tryRenameHeldBackpack", "backpackId", "Ljava/util/UUID;", "backpackName", "", "Listener", "ImprovedBackpacks"})
public final class BackpackManager {
    private static final RegistryCollection<KeybindBackpackAccessor, PriorityQueue<KeybindBackpackAccessor>> keybindAccessors;
    private static final Map<EntityType<?>, EntityBackpackGiver<?>> backpackGivers;
    public static final BackpackManager INSTANCE;

    public final void setup() {
        this.addKeybindAccessor(100, setup.1.INSTANCE);
        FMLJavaModLoadingContext fMLJavaModLoadingContext = FMLJavaModLoadingContext.get();
        Intrinsics.checkNotNullExpressionValue(fMLJavaModLoadingContext, "FMLJavaModLoadingContext.get()");
        fMLJavaModLoadingContext.getModEventBus().addListener((Consumer)setup.2.INSTANCE);
    }

    private final void setupEnd(FMLLoadCompleteEvent event) {
        keybindAccessors.closeRegistry();
    }

    @Nullable
    public final BackpackSlot getBackpackSlotByKeybind(@NotNull ServerPlayerEntity player) {
        Intrinsics.checkNotNullParameter(player, "player");
        for (KeybindBackpackAccessor accessor : keybindAccessors.getValues()) {
            BackpackSlot backpackSlot = AccessUtilsKt.orNull(accessor.getBackpackSlot(player));
            if (backpackSlot == null) {
                continue;
            }
            return backpackSlot;
        }
        return null;
    }

    @Nullable
    public final <T extends Entity> EntityBackpackGiver<T> getBackpackGiver(@NotNull EntityType<T> entityType) {
        Intrinsics.checkNotNullParameter(entityType, "entityType");
        return backpackGivers.get(entityType);
    }

    public final boolean tryOpenBackpack(@NotNull ServerPlayerEntity player, @NotNull BackpackSlot slot) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(slot, "slot");
        ServerBackpackUser serverBackpackUser = BackpackUserKt.getBackpackUser(player);
        if (serverBackpackUser == null) {
            return false;
        }
        ServerBackpackUser user = serverBackpackUser;
        return user.tryOpenBackpackInSlot(slot);
    }

    public final void addKeybindAccessor(int priority, @NotNull Function1<? super ServerPlayerEntity, ? extends Optional<? extends BackpackSlot>> slot) {
        Intrinsics.checkNotNullParameter(slot, "slot");
        keybindAccessors.register(new KeybindBackpackAccessor(priority, slot));
    }

    public final void addBackpackGiver(@NotNull EntityBackpackGiver<?> giver) {
        Intrinsics.checkNotNullParameter(giver, "giver");
        backpackGivers.put(giver.getEntityType(), giver);
    }

    public final void tryRenameHeldBackpack(@NotNull ServerPlayerEntity player, @NotNull UUID backpackId, @NotNull String backpackName) {
        ItemStack heldItem;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(backpackId, "backpackId");
        Intrinsics.checkNotNullParameter(backpackName, "backpackName");
        ItemStack itemStack = heldItem = player.func_184586_b(Hand.MAIN_HAND);
        Intrinsics.checkNotNullExpressionValue(itemStack, "heldItem");
        if (Intrinsics.areEqual(BackpackData.Companion.getUUID(itemStack), backpackId) ^ true) {
            return;
        }
        if (player.field_71068_ca >= IBConfig.INSTANCE.getBackpackRenameLevelCost() || player.func_184812_l_()) {
            if (!player.func_184812_l_()) {
                player.func_82242_a(-IBConfig.INSTANCE.getBackpackRenameLevelCost());
            }
            ItemStack newBackpack = BackpackData.Companion.setName(heldItem, (ITextComponent)new StringTextComponent(backpackName));
            player.func_184611_a(Hand.MAIN_HAND, newBackpack);
            IBCriteriaTriggers.INSTANCE.getBACKPACK_RENAME().trigger(player);
        }
    }

    private BackpackManager() {
    }

    static {
        BackpackManager backpackManager;
        INSTANCE = backpackManager = new BackpackManager();
        keybindAccessors = new RegistryCollection(ImprovedBackpacks.Companion.rangeTo("keybind_accessors"), new PriorityQueue(Comparator.comparingInt(keybindAccessors.1.INSTANCE)));
        boolean bl = false;
        backpackGivers = new LinkedHashMap();
    }

    public static final /* synthetic */ void access$setupEnd(BackpackManager $this, FMLLoadCompleteEvent event) {
        $this.setupEnd(event);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0017H\u0007\u00a8\u0006\u0018"}, d2={"Lcoffee/injected/improvedbackpacks/backpack/BackpackManager$Listener;", "", "()V", "onContainerOpen", "", "event", "Lnet/minecraftforge/event/entity/player/PlayerContainerEvent$Open;", "onEntityJoinWorld", "Lnet/minecraftforge/event/entity/EntityJoinWorldEvent;", "onItemDrop", "onLivingDrops", "Lnet/minecraftforge/event/entity/living/LivingDropsEvent;", "onPlayerChangeDimension", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerChangedDimensionEvent;", "onPlayerDeath", "Lnet/minecraftforge/event/entity/living/LivingDeathEvent;", "onPlayerLogin", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerLoggedInEvent;", "onPlayerLogout", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerLoggedOutEvent;", "onPlayerRespawn", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerRespawnEvent;", "onPlayerTick", "Lnet/minecraftforge/event/TickEvent$PlayerTickEvent;", "ImprovedBackpacks"})
    public static final class Listener {
        public static final Listener INSTANCE;

        @SubscribeEvent
        public final void onContainerOpen(@NotNull PlayerContainerEvent.Open event) {
            Intrinsics.checkNotNullParameter(event, "event");
            PlayerEntity playerEntity = event.getPlayer();
            if (!(playerEntity instanceof ServerPlayerEntity)) {
                playerEntity = null;
            }
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)playerEntity;
            if (serverPlayerEntity == null) {
                return;
            }
            ServerPlayerEntity player = serverPlayerEntity;
            ServerBackpackUser serverBackpackUser = BackpackUserKt.getBackpackUser(player);
            if (serverBackpackUser == null) {
                return;
            }
            ServerBackpackUser backpackUser = serverBackpackUser;
            Container container = event.getContainer();
            Intrinsics.checkNotNullExpressionValue(container, "event.container");
            backpackUser.onContainerOpen(container);
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public final void onPlayerDeath(@NotNull LivingDeathEvent event) {
            block1: {
                Object object;
                Intrinsics.checkNotNullParameter(event, "event");
                Entity entity = event.getEntity();
                if (!(entity instanceof ServerPlayerEntity)) {
                    entity = null;
                }
                if ((object = (ServerPlayerEntity)entity) == null || (object = BackpackUserKt.getBackpackUser((ServerPlayerEntity)object)) == null) break block1;
                ((ServerBackpackUser)object).onPlayerDeath();
            }
        }

        @SubscribeEvent
        public final void onLivingDrops(@NotNull LivingDropsEvent event) {
            block0: {
                Intrinsics.checkNotNullParameter(event, "event");
                BackpackOwner backpackOwner = BackpackOwnerKt.getBackpackOwner(event.getEntityLiving());
                if (backpackOwner == null) break block0;
                backpackOwner.onDeath(event);
            }
        }

        @SubscribeEvent
        public final void onPlayerTick(@NotNull TickEvent.PlayerTickEvent event) {
            block1: {
                Intrinsics.checkNotNullParameter(event, "event");
                if (event.phase != TickEvent.Phase.END) break block1;
                BackpackUser backpackUser = BackpackUserKt.getBackpackUser(event.player);
                if (backpackUser != null) {
                    backpackUser.tick();
                }
            }
        }

        @SubscribeEvent
        public final void onPlayerLogin(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
            block0: {
                Intrinsics.checkNotNullParameter(event, "event");
                BackpackUser backpackUser = BackpackUserKt.getBackpackUser(event.getPlayer());
                if (backpackUser == null) break block0;
                backpackUser.onPlayerJoin();
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public final void onPlayerLogout(@NotNull PlayerEvent.PlayerLoggedOutEvent event) {
            block0: {
                Intrinsics.checkNotNullParameter(event, "event");
                BackpackUser backpackUser = BackpackUserKt.getBackpackUser(event.getPlayer());
                if (backpackUser == null) break block0;
                backpackUser.onPlayerLeave();
            }
        }

        @SubscribeEvent
        public final void onPlayerRespawn(@NotNull PlayerEvent.PlayerRespawnEvent event) {
            block0: {
                Intrinsics.checkNotNullParameter(event, "event");
                BackpackUser backpackUser = BackpackUserKt.getBackpackUser(event.getPlayer());
                if (backpackUser == null) break block0;
                backpackUser.onPlayerRespawn();
            }
        }

        @SubscribeEvent
        public final void onPlayerChangeDimension(@NotNull PlayerEvent.PlayerChangedDimensionEvent event) {
            block0: {
                Intrinsics.checkNotNullParameter(event, "event");
                BackpackUser backpackUser = BackpackUserKt.getBackpackUser(event.getPlayer());
                if (backpackUser == null) break block0;
                backpackUser.onPlayerChangeDimension();
            }
        }

        @SubscribeEvent
        public final void onItemDrop(@NotNull EntityJoinWorldEvent event) {
            ItemEntity itemEntity;
            Intrinsics.checkNotNullParameter(event, "event");
            Entity entity = event.getEntity();
            if (!(entity instanceof ItemEntity)) {
                entity = null;
            }
            if ((itemEntity = (ItemEntity)entity) != null && (itemEntity = itemEntity.func_92059_d()) != null) {
                if (BackpackDataKt.isBackpack((ItemStack)itemEntity, true)) {
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public final void onEntityJoinWorld(@NotNull EntityJoinWorldEvent event) {
            Intrinsics.checkNotNullParameter(event, "event");
            if (event.getWorld().field_72995_K) {
                return;
            }
            Entity entity = event.getEntity();
            if (!(entity instanceof LivingEntity)) {
                entity = null;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity == null) {
                return;
            }
            LivingEntity entity2 = livingEntity;
            BackpackOwner backpackOwner = BackpackOwnerKt.getBackpackOwner(entity2);
            if (backpackOwner == null) {
                return;
            }
            BackpackOwner owner = backpackOwner;
            owner.onJoinWorld();
        }

        private Listener() {
        }

        static {
            Listener listener;
            INSTANCE = listener = new Listener();
        }
    }
}

