/*
 * Decompiled with CFR 0.152.
 */
package coffee.injected.improvedbackpacks.capability.player;

import coffee.injected.improvedbackpacks.backpack.data.BackpackData;
import coffee.injected.improvedbackpacks.backpack.data.BackpackDataKt;
import coffee.injected.improvedbackpacks.backpack.data.OpenedBackpack;
import coffee.injected.improvedbackpacks.backpack.slot.BackpackSlot;
import coffee.injected.improvedbackpacks.backpack.slot.FallbackBackpackSlot;
import coffee.injected.improvedbackpacks.capability.player.BackpackUser;
import coffee.injected.improvedbackpacks.capability.player.BackpackUserKt;
import coffee.injected.improvedbackpacks.container.OpenedBackpackContainer;
import coffee.injected.improvedbackpacks.network.ClosedBackpackPacket;
import coffee.injected.improvedbackpacks.network.OpenedBackpackPacket;
import coffee.injected.improvedbackpacks.network.OpenedEnderBackpackPacket;
import coffee.injected.improvedbackpacks.registry.IBCriteriaTriggers;
import coffee.injected.improvedbackpacks.registry.IBNetwork;
import coffee.injected.improvedbackpacks.registry.IBSounds;
import coffee.injected.improvedbackpacks.util.InvocationUtilsKt;
import java.util.Iterator;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EnderChestInventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001H\u0016J\u001a\u0010\u0010\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0016J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u000eH\u0016J\b\u0010\u001e\u001a\u00020\u000eH\u0016J \u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J\u0010\u0010%\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u001b\u0010&\u001a\u00020\u000e\"\u0004\b\u0000\u0010'2\u0006\u0010(\u001a\u0002H'H\u0002\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020\u0014H\u0016J\b\u0010+\u001a\u00020\u000eH\u0016J\u0018\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u000e\u00101\u001a\u00020\n2\u0006\u0010-\u001a\u00020.R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u00062"}, d2={"Lcoffee/injected/improvedbackpacks/capability/player/ServerBackpackUser;", "Lcoffee/injected/improvedbackpacks/capability/player/BackpackUser;", "player", "Lnet/minecraft/entity/player/ServerPlayerEntity;", "(Lnet/minecraft/entity/player/ServerPlayerEntity;)V", "openedBackpack", "Lcoffee/injected/improvedbackpacks/backpack/data/OpenedBackpack;", "getPlayer", "()Lnet/minecraft/entity/player/ServerPlayerEntity;", "canInteractWithBackpackContainer", "", "backpackId", "Ljava/util/UUID;", "cloneFrom", "", "originalData", "closeBackpack", "playEffects", "deserializeNBT", "nbt", "Lnet/minecraft/nbt/CompoundNBT;", "getOpenedBackpackId", "isIllegalOpenedBackpack", "stack", "Lnet/minecraft/item/ItemStack;", "onContainerOpen", "container", "Lnet/minecraft/inventory/container/Container;", "onPlayerDeath", "onPlayerJoin", "onPlayerLeave", "playSound", "event", "Lnet/minecraft/util/SoundEvent;", "volume", "", "pitch", "scanContainerForIllegalBackpacks", "sendPacket", "MSG", "message", "(Ljava/lang/Object;)V", "serializeNBT", "tick", "tryOpenBackpack", "slot", "Lcoffee/injected/improvedbackpacks/backpack/slot/BackpackSlot;", "data", "Lcoffee/injected/improvedbackpacks/backpack/data/BackpackData;", "tryOpenBackpackInSlot", "ImprovedBackpacks"})
public final class ServerBackpackUser
implements BackpackUser {
    private OpenedBackpack openedBackpack;
    @NotNull
    private final ServerPlayerEntity player;

    @Override
    public void onPlayerJoin() {
        BackpackUser.DefaultImpls.closeBackpack$default(this, null, false, 1, null);
    }

    @Override
    public void tick() {
    }

    @Override
    public void onPlayerLeave() {
        BackpackUser.DefaultImpls.closeBackpack$default(this, null, false, 1, null);
    }

    @Override
    public void onPlayerDeath() {
        BackpackUser.DefaultImpls.closeBackpack$default(this, null, false, 1, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isIllegalOpenedBackpack(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        if (!BackpackDataKt.isBackpack(stack, true)) return false;
        if (this.openedBackpack == null) return true;
        OpenedBackpack openedBackpack = this.openedBackpack;
        Intrinsics.checkNotNull(openedBackpack);
        if (BackpackDataKt.isBackpack(stack, openedBackpack.getData().getUuid(), null)) return false;
        return true;
    }

    public void deserializeNBT(@NotNull CompoundNBT nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        if (nbt.func_74764_b("opened_backpack")) {
            CompoundNBT compoundNBT = nbt.func_74775_l("opened_backpack");
            Intrinsics.checkNotNullExpressionValue(compoundNBT, "nbt.getCompound(\"opened_backpack\")");
            BackpackData backpackData = BackpackData.Companion.deserializeNBT(compoundNBT);
            this.openedBackpack = new OpenedBackpack(FallbackBackpackSlot.INSTANCE, backpackData);
        }
    }

    @Override
    public void cloneFrom(@NotNull BackpackUser originalData) {
        Intrinsics.checkNotNullParameter(originalData, "originalData");
        if (originalData instanceof ServerBackpackUser) {
            this.openedBackpack = ((ServerBackpackUser)originalData).openedBackpack;
        }
    }

    @NotNull
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.openedBackpack != null) {
            OpenedBackpack openedBackpack = this.openedBackpack;
            Intrinsics.checkNotNull(openedBackpack);
            nbt.func_218657_a("opened_backpack", (INBT)openedBackpack.getData().serializeNBT());
        }
        return nbt;
    }

    /*
     * WARNING - void declaration
     */
    public final void scanContainerForIllegalBackpacks(@Nullable Container container) {
        ServerBackpackUser serverBackpackUser = BackpackUserKt.getBackpackUser(this.player);
        if (serverBackpackUser == null) {
            return;
        }
        ServerBackpackUser user = serverBackpackUser;
        int n = 0;
        PlayerInventory playerInventory = this.player.field_71071_by;
        Intrinsics.checkNotNullExpressionValue(playerInventory, "player.inventory");
        int n2 = playerInventory.func_70302_i_();
        while (n < n2) {
            void slot;
            ItemStack stack;
            ItemStack itemStack = stack = this.player.field_71071_by.func_70301_a((int)slot);
            Intrinsics.checkNotNullExpressionValue(itemStack, "stack");
            if (user.isIllegalOpenedBackpack(itemStack)) {
                this.player.field_71071_by.func_70299_a((int)slot, ItemStack.field_190927_a);
            }
            ++slot;
        }
        if (container != null) {
            Iterator iterator2 = container.field_75151_b.iterator();
            while (iterator2.hasNext()) {
                Slot slot;
                Slot slot2 = slot = (Slot)iterator2.next();
                Intrinsics.checkNotNullExpressionValue(slot2, "slot");
                ItemStack itemStack = slot2.func_75211_c();
                Intrinsics.checkNotNullExpressionValue(itemStack, "slot.stack");
                if (!user.isIllegalOpenedBackpack(itemStack)) continue;
                slot.func_75215_d(ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public void closeBackpack(@Nullable UUID backpackId, boolean playEffects) {
        OpenedBackpack openedBackpack = this.openedBackpack;
        if (openedBackpack == null) {
            return;
        }
        OpenedBackpack openedBackpack2 = openedBackpack;
        this.openedBackpack = null;
        openedBackpack2.getData().updateMetadata();
        if (openedBackpack2.getData().getMetadata().isBackpackFull()) {
            IBCriteriaTriggers.INSTANCE.getFULL_BACKPACK().trigger(this.player);
        }
        ItemStack backpackItem = openedBackpack2.getData().createBackpackItem();
        if (!openedBackpack2.getSlot().tryPutBackpack(this, openedBackpack2.getData(), backpackItem)) {
            FallbackBackpackSlot.INSTANCE.tryPutBackpack(this, openedBackpack2.getData(), backpackItem);
        }
        this.scanContainerForIllegalBackpacks(this.player.field_71070_bA);
        UUID openedBackpackId = openedBackpack2.getData().getUuid();
        Container openedContainer = this.player.field_71070_bA;
        if (openedContainer instanceof OpenedBackpackContainer && Intrinsics.areEqual(((OpenedBackpackContainer)openedContainer).getBackpackId(), openedBackpackId)) {
            this.player.func_71128_l();
        }
        this.sendPacket(new ClosedBackpackPacket(openedBackpackId));
        if (playEffects) {
            this.playSound(IBSounds.INSTANCE.getCLOSE_BACKPACK(), 1.0f, 0.85f + this.player.func_70681_au().nextFloat() * 0.4f);
        }
    }

    public final boolean tryOpenBackpackInSlot(@NotNull BackpackSlot slot) {
        Intrinsics.checkNotNullParameter(slot, "slot");
        BackpackData backpackData = slot.getBackpackDataIn(this);
        if (backpackData == null) {
            return false;
        }
        BackpackData data = backpackData;
        return this.tryOpenBackpack(slot, data);
    }

    private final boolean tryOpenBackpack(BackpackSlot slot, BackpackData data) {
        if (this.openedBackpack != null) {
            return false;
        }
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "UUID.randomUUID()");
        data.setUuid(uUID);
        if (!BackpackSlot.tryPutOpenedBackpack$default(slot, this, data, null, 4, null)) {
            return false;
        }
        this.openedBackpack = new OpenedBackpack(slot, data);
        int blockedInvSlot = slot.getBlockedPlayerInventorySlot();
        if (data.getUpgrades().isMaxUpgraded()) {
            IBCriteriaTriggers.INSTANCE.getBACKPACK_MAX_UPGRADE().trigger(this.player);
        }
        this.sendPacket(new OpenedBackpackPacket(data.getUuid(), data.getColor(), data.getMetadata().getSlots(), data.getUpgrades(), blockedInvSlot));
        World world = this.player.field_70170_p;
        if (world == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.minecraft.world.server.ServerWorld");
        }
        data.handleOpening((ServerWorld)world, this.player);
        this.player.func_213829_a((INamedContainerProvider)new OpenedBackpackContainer.Provider(data, blockedInvSlot));
        this.playSound(IBSounds.INSTANCE.getOPEN_BACKPACK(), 1.0f, 0.85f + this.player.func_70681_au().nextFloat() * 0.4f);
        return true;
    }

    @Override
    public boolean canInteractWithBackpackContainer(@NotNull UUID backpackId) {
        Intrinsics.checkNotNullParameter(backpackId, "backpackId");
        Object object = this.openedBackpack;
        return object != null && (object = ((OpenedBackpack)object).getSlot()) != null && ((BackpackSlot)object).hasBackpackIn(this, backpackId, true);
    }

    @Override
    @Nullable
    public UUID getOpenedBackpackId() {
        Object object = this.openedBackpack;
        return object != null && (object = ((OpenedBackpack)object).getData()) != null ? ((BackpackData)object).getUuid() : null;
    }

    public final void onContainerOpen(@NotNull Container container) {
        Intrinsics.checkNotNullParameter(container, "container");
        this.scanContainerForIllegalBackpacks(container);
        if (container instanceof ChestContainer && ((ChestContainer)container).func_85151_d() instanceof EnderChestInventory) {
            this.sendPacket(new OpenedEnderBackpackPacket(container.field_75152_c));
        }
    }

    private final void playSound(SoundEvent event, float volume, float pitch) {
        double d = Math.toRadians((double)this.player.field_70759_as + 90.0);
        boolean bl = false;
        double dx = Math.cos(d) * 0.5;
        double d2 = Math.toRadians((double)this.player.field_70759_as + 90.0);
        boolean bl2 = false;
        double dz = Math.sin(d2) * 0.5;
        this.player.field_70170_p.func_184148_a(null, this.player.func_226277_ct_() + dx, this.player.func_226278_cu_() + (double)this.player.func_70047_e(), this.player.func_226281_cx_() + dz, event, SoundCategory.PLAYERS, volume, pitch);
    }

    private final <MSG> void sendPacket(MSG message) {
        SimpleChannel simpleChannel = IBNetwork.INSTANCE.getChannel();
        Intrinsics.checkNotNullExpressionValue(simpleChannel, "IBNetwork.channel");
        InvocationUtilsKt.send(this.player, simpleChannel, message);
    }

    @NotNull
    public final ServerPlayerEntity getPlayer() {
        return this.player;
    }

    public ServerBackpackUser(@NotNull ServerPlayerEntity player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.player = player;
    }

    @Override
    public void onPlayerRespawn() {
        BackpackUser.DefaultImpls.onPlayerRespawn(this);
    }

    @Override
    public void onPlayerChangeDimension() {
        BackpackUser.DefaultImpls.onPlayerChangeDimension(this);
    }
}

