/*
 * Decompiled with CFR 0.152.
 */
package coffee.injected.improvedbackpacks.recipe;

import coffee.injected.improvedbackpacks.recipe.AbstractSewingRecipe;
import coffee.injected.improvedbackpacks.recipe.SewingRecipeDescriptor;
import coffee.injected.improvedbackpacks.util.TransformUtilsKt;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001%B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\b\u0010\u001b\u001a\u00020\fH\u0016J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\fH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\fH\u0002J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\fH\u0002J\u0018\u0010$\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0018\u0010\u0013\u001a\u00020\u0014*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015\u00a8\u0006&"}, d2={"Lcoffee/injected/improvedbackpacks/recipe/SewingRecipe;", "Lcoffee/injected/improvedbackpacks/recipe/AbstractSewingRecipe;", "id", "Lnet/minecraft/util/ResourceLocation;", "firstIngredient", "Lnet/minecraft/item/crafting/Ingredient;", "firstIngredientCount", "", "secondIngredient", "secondIngredientCount", "spoolsCount", "result", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/item/crafting/Ingredient;ILnet/minecraft/item/crafting/Ingredient;IILnet/minecraft/item/ItemStack;)V", "getFirstIngredient", "()Lnet/minecraft/item/crafting/Ingredient;", "getResult", "()Lnet/minecraft/item/ItemStack;", "getSecondIngredient", "isEmpty", "", "(Lnet/minecraft/item/crafting/Ingredient;)Z", "getDescriptors", "", "target", "", "Lcoffee/injected/improvedbackpacks/recipe/SewingRecipeDescriptor;", "getRecipeOutput", "getResultStack", "stack1", "stack2", "getSerializer", "Lcoffee/injected/improvedbackpacks/recipe/SewingRecipe$Serializer;", "isFirstIngredient", "stack", "isSecondIngredient", "matches", "Serializer", "ImprovedBackpacks"})
public final class SewingRecipe
extends AbstractSewingRecipe {
    @NotNull
    private final Ingredient firstIngredient;
    @NotNull
    private final Ingredient secondIngredient;
    @NotNull
    private final ItemStack result;

    @Override
    public boolean matches(@NotNull ItemStack stack1, @NotNull ItemStack stack2) {
        Intrinsics.checkNotNullParameter(stack1, "stack1");
        Intrinsics.checkNotNullParameter(stack2, "stack2");
        return this.isFirstIngredient(stack1) && this.isSecondIngredient(stack2);
    }

    @Override
    @NotNull
    public ItemStack getResultStack(@NotNull ItemStack stack1, @NotNull ItemStack stack2) {
        Intrinsics.checkNotNullParameter(stack1, "stack1");
        Intrinsics.checkNotNullParameter(stack2, "stack2");
        ItemStack itemStack = this.result.func_77946_l();
        Intrinsics.checkNotNullExpressionValue(itemStack, "result.copy()");
        return itemStack;
    }

    @NotNull
    public ItemStack func_77571_b() {
        ItemStack itemStack = this.result.func_77946_l();
        Intrinsics.checkNotNullExpressionValue(itemStack, "result.copy()");
        return itemStack;
    }

    @NotNull
    public Serializer getSerializer() {
        return Serializer.INSTANCE;
    }

    private final boolean isFirstIngredient(ItemStack stack) {
        return this.firstIngredient.test(stack) || this.isEmpty(this.firstIngredient) && stack.func_190926_b();
    }

    private final boolean isSecondIngredient(ItemStack stack) {
        return this.secondIngredient.test(stack) || this.isEmpty(this.secondIngredient) && stack.func_190926_b();
    }

    private final boolean isEmpty(Ingredient $this$isEmpty) {
        return $this$isEmpty == Ingredient.field_193370_a;
    }

    @Override
    public void getDescriptors(@NotNull List<SewingRecipeDescriptor> target) {
        Intrinsics.checkNotNullParameter(target, "target");
        Collection collection = target;
        int n = this.getSpoolsCount();
        Ingredient ingredient = TransformUtilsKt.withAmount(this.firstIngredient, this.getFirstIngredientCount());
        Ingredient ingredient2 = TransformUtilsKt.withAmount(this.secondIngredient, this.getSecondIngredientCount());
        ItemStack itemStack = this.result.func_77946_l();
        Intrinsics.checkNotNullExpressionValue(itemStack, "result.copy()");
        SewingRecipeDescriptor sewingRecipeDescriptor = new SewingRecipeDescriptor(n, ingredient, ingredient2, itemStack, 1000);
        boolean bl = false;
        collection.add(sewingRecipeDescriptor);
    }

    @NotNull
    public final Ingredient getFirstIngredient() {
        return this.firstIngredient;
    }

    @NotNull
    public final Ingredient getSecondIngredient() {
        return this.secondIngredient;
    }

    @NotNull
    public final ItemStack getResult() {
        return this.result;
    }

    public SewingRecipe(@NotNull ResourceLocation id, @NotNull Ingredient firstIngredient, int firstIngredientCount, @NotNull Ingredient secondIngredient, int secondIngredientCount, int spoolsCount, @NotNull ItemStack result) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(firstIngredient, "firstIngredient");
        Intrinsics.checkNotNullParameter(secondIngredient, "secondIngredient");
        Intrinsics.checkNotNullParameter(result, "result");
        super(id, firstIngredientCount, secondIngredientCount, spoolsCount);
        this.firstIngredient = firstIngredient;
        this.secondIngredient = secondIngredient;
        this.result = result;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016\u00a8\u0006\u000f"}, d2={"Lcoffee/injected/improvedbackpacks/recipe/SewingRecipe$Serializer;", "Lnet/minecraftforge/registries/ForgeRegistryEntry;", "Lnet/minecraft/item/crafting/IRecipeSerializer;", "Lcoffee/injected/improvedbackpacks/recipe/SewingRecipe;", "()V", "read", "recipeId", "Lnet/minecraft/util/ResourceLocation;", "json", "Lcom/google/gson/JsonObject;", "buffer", "Lnet/minecraft/network/PacketBuffer;", "write", "", "recipe", "ImprovedBackpacks"})
    public static final class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SewingRecipe> {
        public static final Serializer INSTANCE;

        public void write(@NotNull PacketBuffer buffer, @NotNull SewingRecipe recipe) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            Intrinsics.checkNotNullParameter(recipe, "recipe");
            recipe.getFirstIngredient().func_199564_a(buffer);
            buffer.writeInt(recipe.getFirstIngredientCount());
            recipe.getSecondIngredient().func_199564_a(buffer);
            buffer.writeInt(recipe.getSecondIngredientCount());
            buffer.writeInt(recipe.getSpoolsCount());
            buffer.func_150788_a(recipe.getResult());
        }

        @NotNull
        public SewingRecipe read(@NotNull ResourceLocation recipeId, @NotNull PacketBuffer buffer) {
            Intrinsics.checkNotNullParameter(recipeId, "recipeId");
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            Intrinsics.checkNotNullExpressionValue(ingredient, "Ingredient.read(buffer)");
            int n = buffer.readInt();
            Ingredient ingredient2 = Ingredient.func_199566_b((PacketBuffer)buffer);
            Intrinsics.checkNotNullExpressionValue(ingredient2, "Ingredient.read(buffer)");
            int n2 = buffer.readInt();
            int n3 = buffer.readInt();
            ItemStack itemStack = buffer.func_150791_c();
            Intrinsics.checkNotNullExpressionValue(itemStack, "buffer.readItemStack()");
            return new SewingRecipe(recipeId, ingredient, n, ingredient2, n2, n3, itemStack);
        }

        @NotNull
        public SewingRecipe read(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            JsonElement resultElement;
            Ingredient second;
            Ingredient ingredient;
            Ingredient ingredient2;
            Intrinsics.checkNotNullParameter(recipeId, "recipeId");
            Intrinsics.checkNotNullParameter(json, "json");
            if (json.has("first")) {
                JsonElement ingredientElement = JSONUtils.func_151202_d((JsonObject)json, (String)"first") ? (JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"first") : (JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"first");
                ingredient2 = Ingredient.func_199802_a((JsonElement)ingredientElement);
            } else {
                ingredient2 = null;
            }
            Ingredient first = ingredient2;
            int firstCount = JSONUtils.func_151208_a((JsonObject)json, (String)"first_count", (int)1);
            if (json.has("second")) {
                JsonElement ingredientElement = JSONUtils.func_151202_d((JsonObject)json, (String)"second") ? (JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"second") : (JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"second");
                ingredient = Ingredient.func_199802_a((JsonElement)ingredientElement);
            } else {
                ingredient = second = null;
            }
            if (first == null && second == null) {
                throw (Throwable)new IllegalStateException("At least one ingredient must be presented");
            }
            int secondCount = JSONUtils.func_151208_a((JsonObject)json, (String)"second_count", (int)1);
            if (!json.has("result")) {
                throw (Throwable)new JsonSyntaxException("Missing result item stack");
            }
            JsonElement jsonElement = resultElement = json.get("result");
            Intrinsics.checkNotNullExpressionValue(jsonElement, "resultElement");
            ItemStack result = jsonElement.isJsonObject() ? ShapedRecipe.func_199798_a((JsonObject)resultElement.getAsJsonObject()) : new ItemStack((IItemProvider)Registry.field_212630_s.func_82594_a(new ResourceLocation(resultElement.getAsString())));
            int spoolsCount = JSONUtils.func_151208_a((JsonObject)json, (String)"spools_count", (int)1);
            ItemStack itemStack = result;
            Intrinsics.checkNotNullExpressionValue(itemStack, "result");
            if (itemStack.func_190916_E() != 1) {
                throw (Throwable)new IllegalArgumentException("Unexpected result stack size (only 1 is allowed)");
            }
            Ingredient ingredient3 = first;
            if (ingredient3 == null) {
                ingredient3 = Ingredient.field_193370_a;
            }
            Intrinsics.checkNotNullExpressionValue(ingredient3, "first ?: Ingredient.EMPTY");
            int n = first == null ? 0 : firstCount;
            Ingredient ingredient4 = second;
            if (ingredient4 == null) {
                ingredient4 = Ingredient.field_193370_a;
            }
            Intrinsics.checkNotNullExpressionValue(ingredient4, "second ?: Ingredient.EMPTY");
            return new SewingRecipe(recipeId, ingredient3, n, ingredient4, second == null ? 0 : secondCount, spoolsCount, result);
        }

        private Serializer() {
        }

        static {
            Serializer serializer;
            INSTANCE = serializer = new Serializer();
        }
    }
}

