/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.google.common.collect.AbstractIterator;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeTagHandler;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class TagCollectionArgument
implements ArgumentType<Result> {
    private static final Collection<String> EXAMPLES = Arrays.asList("minecraft:blocks", "minecraft:enchantments");
    private static final Iterable<ResourceLocation> ALL_COLLECTIONS_ITERABLE = () -> new CollectionIterator();
    private static final DynamicCommandExceptionType TAG_COLLECTION_NOT_FOUND = new DynamicCommandExceptionType(name -> new TranslationTextComponent("command.mantle.tag_collection.not_found", new Object[]{name}));

    @Nullable
    private static Result getVanillaTags(ForgeRegistry<?> registry, ResourceLocation name) {
        for (VanillaTagType type : VanillaTagType.values()) {
            if (!name.equals((Object)type.getName())) continue;
            return Result.of(name, type.getTagFolder(), registry, type.getCollection());
        }
        return null;
    }

    public Result parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation name = ResourceLocation.func_195826_a((StringReader)reader);
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(name);
        if (registry != null) {
            Result result = TagCollectionArgument.getVanillaTags(registry, name);
            if (result != null) {
                return result;
            }
            ITagCollection collection = (ITagCollection)ForgeTagHandler.getCustomTagTypes().get(name);
            String tagFolder = registry.getTagFolder();
            if (collection != null && tagFolder != null) {
                return Result.of(name, tagFolder, registry, collection);
            }
        }
        throw TAG_COLLECTION_NOT_FOUND.create((Object)name);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197014_a(ALL_COLLECTIONS_ITERABLE, (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private TagCollectionArgument() {
    }

    public static TagCollectionArgument collection() {
        return new TagCollectionArgument();
    }

    private static class CollectionIterator
    extends AbstractIterator<ResourceLocation> {
        private VanillaTagType nextVanilla = VanillaTagType.BLOCK;
        private final Iterator<ResourceLocation> forgeIterator = ForgeTagHandler.getCustomTagTypeNames().iterator();

        private CollectionIterator() {
        }

        protected ResourceLocation computeNext() {
            if (this.nextVanilla != null) {
                VanillaTagType[] values;
                ResourceLocation result = this.nextVanilla.getName();
                int nextIndex = this.nextVanilla.ordinal() + 1;
                this.nextVanilla = nextIndex < (values = VanillaTagType.values()).length ? values[nextIndex] : null;
                return result;
            }
            if (this.forgeIterator.hasNext()) {
                return this.forgeIterator.next();
            }
            return (ResourceLocation)this.endOfData();
        }
    }

    protected static enum VanillaTagType {
        BLOCK(Registry.field_239711_l_.func_240901_a_(), () -> TagCollectionManager.func_242178_a().func_241835_a()),
        ITEM(Registry.field_239714_o_.func_240901_a_(), () -> TagCollectionManager.func_242178_a().func_241836_b()),
        FLUID(Registry.field_239709_j_.func_240901_a_(), () -> TagCollectionManager.func_242178_a().func_241837_c()),
        ENTITY_TYPE(Registry.field_239713_n_.func_240901_a_(), () -> TagCollectionManager.func_242178_a().func_241838_d());

        private final ResourceLocation name;
        private final Supplier<ITagCollection<?>> supplier;

        public ITagCollection<?> getCollection() {
            return this.supplier.get();
        }

        public String getTagFolder() {
            return this.name.func_110623_a() + "s";
        }

        private VanillaTagType(ResourceLocation name, Supplier<ITagCollection<?>> supplier) {
            this.name = name;
            this.supplier = supplier;
        }

        public ResourceLocation getName() {
            return this.name;
        }
    }

    public static class Result {
        private final ResourceLocation name;
        private final String tagFolder;
        private final ForgeRegistry<?> registry;
        private final ITagCollection<?> collection;

        private Result(ResourceLocation name, String tagFolder, ForgeRegistry<?> registry, ITagCollection<?> collection) {
            this.name = name;
            this.tagFolder = tagFolder;
            this.registry = registry;
            this.collection = collection;
        }

        public static Result of(ResourceLocation name, String tagFolder, ForgeRegistry<?> registry, ITagCollection<?> collection) {
            return new Result(name, tagFolder, registry, collection);
        }

        public ResourceLocation getName() {
            return this.name;
        }

        public String getTagFolder() {
            return this.tagFolder;
        }

        public ForgeRegistry<?> getRegistry() {
            return this.registry;
        }

        public ITagCollection<?> getCollection() {
            return this.collection;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ResourceLocation this$name = this.getName();
            ResourceLocation other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$tagFolder = this.getTagFolder();
            String other$tagFolder = other.getTagFolder();
            if (this$tagFolder == null ? other$tagFolder != null : !this$tagFolder.equals(other$tagFolder)) {
                return false;
            }
            ForgeRegistry<?> this$registry = this.getRegistry();
            ForgeRegistry<?> other$registry = other.getRegistry();
            if (this$registry == null ? other$registry != null : !this$registry.equals(other$registry)) {
                return false;
            }
            ITagCollection<?> this$collection = this.getCollection();
            ITagCollection<?> other$collection = other.getCollection();
            return !(this$collection == null ? other$collection != null : !this$collection.equals(other$collection));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ResourceLocation $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $tagFolder = this.getTagFolder();
            result = result * 59 + ($tagFolder == null ? 43 : $tagFolder.hashCode());
            ForgeRegistry<?> $registry = this.getRegistry();
            result = result * 59 + ($registry == null ? 43 : $registry.hashCode());
            ITagCollection<?> $collection = this.getCollection();
            result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
            return result;
        }

        public String toString() {
            return "TagCollectionArgument.Result(name=" + this.getName() + ", tagFolder=" + this.getTagFolder() + ", registry=" + this.getRegistry() + ", collection=" + this.getCollection() + ")";
        }
    }
}

