/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot.function;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.loot.MantleLoot;
import slimeknights.mantle.recipe.RecipeHelper;

public class SetFluidLootFunction
extends LootFunction {
    public static final Serializer SERIALIZER = new Serializer();
    private final FluidStack fluid;

    protected SetFluidLootFunction(ILootCondition[] conditionsIn, FluidStack fluid) {
        super(conditionsIn);
        this.fluid = fluid;
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> {
            handler.fill(this.fluid.copy(), IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }).orElse(stack);
    }

    public LootFunctionType func_230425_b_() {
        return MantleLoot.SET_FLUID_FUNCTION;
    }

    public static LootFunction.Builder<?> builder(FluidStack fluid) {
        return SetFluidLootFunction.func_215860_a(conditions -> new SetFluidLootFunction((ILootCondition[])conditions, fluid));
    }

    private static class Serializer
    extends LootFunction.Serializer<SetFluidLootFunction> {
        private Serializer() {
        }

        public void serialize(JsonObject json, SetFluidLootFunction loot, JsonSerializationContext context) {
            super.func_230424_a_(json, (LootFunction)loot, context);
            json.add("fluid", (JsonElement)RecipeHelper.serializeFluidStack(loot.fluid));
        }

        public SetFluidLootFunction deserialize(JsonObject object, JsonDeserializationContext context, ILootCondition[] conditions) {
            FluidStack fluid = RecipeHelper.deserializeFluidStack(JSONUtils.func_152754_s((JsonObject)object, (String)"fluid"));
            return new SetFluidLootFunction(conditions, fluid);
        }
    }
}

