/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.adapter;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.data.BlockStateVariantBuilder;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.SignItem;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.TallBlockItem;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.mantle.item.BurnableBlockItem;
import slimeknights.mantle.item.BurnableSignItem;
import slimeknights.mantle.item.BurnableTallBlockItem;
import slimeknights.mantle.item.TooltipItem;
import slimeknights.mantle.registration.ItemProperties;
import slimeknights.mantle.registration.adapter.EnumRegistryAdapter;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.FenceBuildingBlockObject;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;
import slimeknights.mantle.registration.object.WoodBlockObject;

public class ItemRegistryAdapter
extends EnumRegistryAdapter<Item> {
    private final Item.Properties defaultProps;

    public ItemRegistryAdapter(IForgeRegistry<Item> registry) {
        this(registry, (Item.Properties)null);
    }

    public ItemRegistryAdapter(IForgeRegistry<Item> registry, @Nullable Item.Properties defaultProps) {
        super(registry);
        this.defaultProps = defaultProps == null ? new Item.Properties() : defaultProps;
    }

    public ItemRegistryAdapter(IForgeRegistry<Item> registry, String modid, @Nullable Item.Properties defaultProps) {
        super(registry, modid);
        this.defaultProps = defaultProps == null ? new Item.Properties() : defaultProps;
    }

    public TooltipItem registerDefault(String name) {
        return this.register(this.defaultProps, name);
    }

    @Override
    public TooltipItem register(Item.Properties props, String name) {
        return this.register(new TooltipItem(props), name);
    }

    public <T extends Item> T registerDefault(Function<Item.Properties, T> constructor, String name) {
        return (T)((Item)this.register((IForgeRegistryEntry)constructor.apply(this.defaultProps), name));
    }

    public BlockItem registerDefaultBlockItem(Block block) {
        return this.registerBlockItem(block, this.defaultProps);
    }

    public <T extends BlockItem> T registerBlockItem(Block block, BiFunction<Block, Item.Properties, T> constructor) {
        return (T)((BlockItem)this.register((IForgeRegistryEntry)constructor.apply(block, this.defaultProps), (IForgeRegistryEntry<?>)block));
    }

    public BlockItem registerBlockItem(Block block, Item.Properties props) {
        return this.register(new BlockTooltipItem(block, props), (IForgeRegistryEntry<?>)block);
    }

    public <T extends BlockItem> T registerBlockItem(T blockItem) {
        return this.register(blockItem, (IForgeRegistryEntry<?>)blockItem.func_179223_d());
    }

    public void registerDefaultBlockItem(BuildingBlockObject object) {
        this.registerDefaultBlockItem((Block)object.get());
        this.registerDefaultBlockItem((Block)object.getSlab());
        this.registerDefaultBlockItem((Block)object.getStairs());
    }

    public void registerDefaultBlockItem(WallBuildingBlockObject object) {
        this.registerDefaultBlockItem((BuildingBlockObject)object);
        this.registerDefaultBlockItem((Block)object.getWall());
    }

    public void registerDefaultBlockItem(FenceBuildingBlockObject object) {
        this.registerDefaultBlockItem((BuildingBlockObject)object);
        this.registerDefaultBlockItem((Block)object.getFence());
    }

    public void registerDefaultBlockItem(WoodBlockObject object, boolean isBurnable) {
        BlockStateVariantBuilder.ITriFunction burnableSignItem;
        Function<Block, BlockItem> burnableTallItem;
        BiFunction<Block, Integer, BlockItem> burnableItem;
        if (isBurnable) {
            burnableItem = (block, burnTime) -> new BurnableBlockItem((Block)block, this.defaultProps, (int)burnTime);
            burnableTallItem = block -> new BurnableTallBlockItem((Block)block, this.defaultProps, 200);
            burnableSignItem = (props, standing, wall) -> new BurnableSignItem((Item.Properties)props, (Block)standing, (Block)wall, 200);
        } else {
            burnableItem = (block, burnTime) -> new BlockItem(block, this.defaultProps);
            burnableTallItem = block -> new TallBlockItem(block, this.defaultProps);
            burnableSignItem = SignItem::new;
        }
        BlockItem planks = this.registerBlockItem(burnableItem.apply((Block)object.get(), 300));
        this.registerBlockItem(burnableItem.apply((Block)object.getSlab(), 150));
        this.registerBlockItem(burnableItem.apply((Block)object.getStairs(), 300));
        this.registerBlockItem(burnableItem.apply((Block)object.getFence(), 300));
        this.registerBlockItem(burnableItem.apply(object.getLog(), 300));
        this.registerBlockItem(burnableItem.apply(object.getWood(), 300));
        this.registerBlockItem(burnableItem.apply(object.getStrippedLog(), 300));
        this.registerBlockItem(burnableItem.apply(object.getStrippedWood(), 300));
        this.registerBlockItem(burnableTallItem.apply((Block)object.getDoor()));
        this.registerBlockItem(burnableItem.apply((Block)object.getTrapdoor(), 300));
        this.registerBlockItem(burnableItem.apply((Block)object.getFenceGate(), 300));
        this.registerBlockItem(burnableItem.apply((Block)object.getPressurePlate(), 300));
        this.registerBlockItem(burnableItem.apply((Block)object.getButton(), 100));
        this.registerBlockItem((BlockItem)burnableSignItem.apply((Object)new Item.Properties().func_200917_a(16).func_200916_a(planks.func_77640_w()), (Object)object.getSign(), (Object)object.getWallSign()));
    }

    public void registerDefaultBlockItem(EnumObject<?, ? extends Block> enumObject) {
        enumObject.values().forEach(this::registerDefaultBlockItem);
    }

    public <B extends Block> void registerBlockItem(EnumObject<?, B> enumObject, Item.Properties props) {
        enumObject.values().forEach(block -> this.registerBlockItem((Block)block, props));
    }

    public <B extends Block> void registerBlockItem(EnumObject<?, B> enumObject, Function<B, ? extends BlockItem> blockItem) {
        enumObject.values().forEach(block -> this.registerBlockItem((BlockItem)blockItem.apply(block)));
    }

    public BucketItem registerBucket(Supplier<? extends Fluid> fluid, String baseName) {
        return this.register(new BucketItem(fluid, ItemProperties.BUCKET_PROPS), baseName + "_bucket");
    }

    public SpawnEggItem registerSpawnEgg(EntityType<?> entity, int primary, int secondary, String baseName) {
        return this.register(new SpawnEggItem(entity, primary, secondary, ItemProperties.EGG_PROPS), baseName + "_spawn_egg");
    }
}

