/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outerend.client.entity.model;

import blueduck.outerend.entities.StalkerEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;

public class StalkerModel<T extends Entity>
extends AgeableModel<StalkerEntity> {
    private final ModelRenderer rearFootLeft;
    private final ModelRenderer rearFootRight;
    private final ModelRenderer haunchLeft;
    private final ModelRenderer haunchRight;
    private final ModelRenderer body;
    private final ModelRenderer frontLegLeft;
    private final ModelRenderer bone4;
    private final ModelRenderer frontLegRight;
    private final ModelRenderer bone;
    private final ModelRenderer head;
    private final ModelRenderer bone2;
    private final ModelRenderer tail;
    private final ModelRenderer bone3;
    private final ModelRenderer getHead;

    public StalkerModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.rearFootLeft = new ModelRenderer((Model)this);
        this.rearFootLeft.func_78793_a(-3.0f, 17.5f, 3.7f);
        this.rearFootRight = new ModelRenderer((Model)this);
        this.rearFootRight.func_78793_a(3.0f, 17.5f, 3.7f);
        this.haunchLeft = new ModelRenderer((Model)this);
        this.haunchLeft.func_78793_a(-5.25f, -3.2424f, 3.2f);
        this.haunchLeft.func_78784_a(0, 26).func_228303_a_(-1.75f, -2.2576f, -4.5f, 3.0f, 12.0f, 7.0f, 0.0f, false);
        this.haunchLeft.func_78784_a(79, 61).func_228303_a_(-0.75f, 9.7424f, -0.5f, 2.0f, 17.0f, 3.0f, 0.0f, false);
        this.haunchRight = new ModelRenderer((Model)this);
        this.haunchRight.func_78793_a(4.25f, -3.2424f, 2.851f);
        this.haunchRight.func_78784_a(0, 26).func_228303_a_(-1.25f, -2.25f, -4.5f, 3.0f, 12.0f, 7.0f, 0.0f, false);
        this.haunchRight.func_78784_a(79, 61).func_228303_a_(-1.25f, 9.75f, -0.5f, 2.0f, 17.0f, 3.0f, 0.0f, false);
        this.body = new ModelRenderer((Model)this);
        this.body.func_78793_a(0.0f, 1.0f, 6.0f);
        this.setRotationAngle(this.body, -0.1745f, 0.0f, 0.0f);
        this.body.func_78784_a(0, 0).func_228303_a_(-4.0f, -5.637f, -24.1599f, 7.0f, 6.0f, 20.0f, 0.0f, false);
        this.body.func_78784_a(0, 26).func_228303_a_(-1.0f, -6.5762f, -24.8545f, 1.0f, 2.0f, 21.0f, 0.0f, false);
        this.frontLegLeft = new ModelRenderer((Model)this);
        this.frontLegLeft.func_78793_a(-3.75f, -5.0f, -12.5f);
        this.frontLegLeft.func_78784_a(0, 26).func_228303_a_(-3.25f, -2.0f, -2.5f, 3.0f, 14.0f, 5.0f, 0.0f, false);
        this.bone4 = new ModelRenderer((Model)this);
        this.bone4.func_78793_a(-1.75f, 11.5f, 1.5f);
        this.frontLegLeft.func_78792_a(this.bone4);
        this.bone4.func_78784_a(80, 61).func_228303_a_(-1.0f, 0.5f, -2.0f, 2.0f, 17.0f, 4.0f, 0.0f, false);
        this.frontLegRight = new ModelRenderer((Model)this);
        this.frontLegRight.func_78793_a(2.0f, -5.0f, -12.5f);
        this.frontLegRight.func_78784_a(1, 26).func_228303_a_(1.0f, -1.6947f, -2.4933f, 3.0f, 14.0f, 5.0f, 0.0f, false);
        this.bone = new ModelRenderer((Model)this);
        this.bone.func_78793_a(2.5f, 11.8053f, 1.5067f);
        this.frontLegRight.func_78792_a(this.bone);
        this.bone.func_78784_a(80, 61).func_228303_a_(-1.0f, 0.5f, -2.0f, 2.0f, 17.0f, 4.0f, 0.0f, false);
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(-0.5f, -7.0f, -17.1667f);
        this.head.func_78784_a(25, 26).func_228303_a_(-2.0f, -5.0f, -4.8333f, 4.0f, 9.0f, 5.0f, 0.0f, false);
        this.head.func_78784_a(0, 0).func_228303_a_(-1.0f, -3.0f, -5.9333f, 2.0f, 5.0f, 1.0f, 0.0f, false);
        this.bone2 = new ModelRenderer((Model)this);
        this.bone2.func_78793_a(0.0f, -5.0f, -1.3333f);
        this.head.func_78792_a(this.bone2);
        this.setRotationAngle(this.bone2, 0.1309f, 0.0f, -0.0436f);
        this.bone2.func_78784_a(45, 18).func_228303_a_(-1.0f, -1.0f, -1.5f, 2.0f, 2.0f, 9.0f, 0.0f, false);
        this.tail = new ModelRenderer((Model)this);
        this.tail.func_78793_a(-0.3333f, -3.9352f, 3.0711f);
        this.setRotationAngle(this.tail, -0.48f, 0.0f, 0.0f);
        this.tail.func_78784_a(29, 32).func_228303_a_(-1.6667f, -0.8172f, -1.5857f, 3.0f, 5.0f, 17.0f, 0.0f, false);
        this.tail.func_78784_a(34, 0).func_228303_a_(-0.6667f, -1.3681f, -1.3432f, 1.0f, 1.0f, 17.0f, 0.0f, false);
        this.bone3 = new ModelRenderer((Model)this);
        this.bone3.func_78793_a(-0.1667f, 1.6021f, 15.1508f);
        this.tail.func_78792_a(this.bone3);
        this.setRotationAngle(this.bone3, -0.1309f, 0.0f, 0.0f);
        this.bone3.func_78784_a(0, 49).func_228303_a_(-0.5f, -2.0f, -0.5f, 1.0f, 4.0f, 13.0f, 0.0f, false);
        this.getHead = new ModelRenderer((Model)this);
        this.getHead.func_78793_a(0.0f, 0.0f, 0.0f);
    }

    public void setRotationAngles(StalkerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.frontLegRight.field_78795_f = (float)(Math.sin(limbSwing / 2.0f) * (double)(limbSwingAmount / 2.0f));
        this.frontLegLeft.field_78795_f = -this.frontLegRight.field_78795_f;
        this.haunchRight.field_78795_f = -this.frontLegRight.field_78795_f;
        this.haunchLeft.field_78795_f = this.frontLegRight.field_78795_f;
        this.tail.field_78795_f = (float)(Math.toRadians(-27.5) + Math.sin(ageInTicks / 16.0f) / 32.0);
        this.tail.field_78795_f += (float)(Math.sin(limbSwing / 4.0f) * (double)(limbSwingAmount / 16.0f));
        this.bone3.field_78795_f = (float)((double)this.tail.field_78795_f - Math.toRadians(-20.5)) * 2.0f;
        this.head.field_78795_f = (float)Math.toRadians(headPitch + 12.0f);
        this.head.field_78796_g = (float)Math.toRadians(netHeadYaw);
        float wanted = entity.func_233678_J__() ? (float)(Math.cos(ageInTicks / 24.0f) * Math.toRadians(10.0) + Math.toRadians(70.0)) - this.head.field_78795_f : (float)(Math.cos(ageInTicks / 32.0f) * 0.25 + Math.toRadians(15.0)) - this.head.field_78795_f;
        float delta = wanted - this.bone2.field_78795_f;
        if ((double)Math.abs(delta) < Math.toRadians(2.0)) {
            this.bone2.field_78795_f = wanted;
        } else {
            float damp = 0.5f;
            delta = Math.min(delta * damp, (float)Math.toRadians(0.5));
            this.bone2.field_78795_f += delta;
        }
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.rearFootLeft.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.rearFootRight.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.haunchLeft.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.haunchRight.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.body.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.frontLegLeft.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.frontLegRight.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.head.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.tail.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
    }

    public Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.head);
    }

    public Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

