/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outerend.client.entity.renderer;

import blueduck.outerend.OuterEndMod;
import blueduck.outerend.client.entity.model.ChorusSquidModel;
import blueduck.outerend.entities.ChorusSquidEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChorusSquidRenderer
extends MobRenderer<ChorusSquidEntity, ChorusSquidModel> {
    private static final ResourceLocation TEXTURE_INACTIVE = new ResourceLocation(OuterEndMod.MODID, "textures/entity/chorus_squid_inactive.png");
    private static final ResourceLocation TEXTURE_ACTIVE = new ResourceLocation(OuterEndMod.MODID, "textures/entity/chorus_squid_active.png");

    public ChorusSquidRenderer(EntityRendererManager renderManager) {
        super(renderManager, (EntityModel)new ChorusSquidModel(), 0.7f);
    }

    public ResourceLocation getEntityTexture(ChorusSquidEntity squid) {
        if (squid.getSquidMode() == ChorusSquidEntity.ChorusSquidMode.IDLE) {
            return TEXTURE_INACTIVE;
        }
        return TEXTURE_ACTIVE;
    }

    public void render(ChorusSquidEntity squid, float p_225623_2_, float p_225623_3_, MatrixStack p_225623_4_, IRenderTypeBuffer p_225623_5_, int p_225623_6_) {
        super.func_225623_a_((MobEntity)squid, p_225623_2_, p_225623_3_, p_225623_4_, p_225623_5_, p_225623_6_);
    }

    protected void applyRotations(ChorusSquidEntity squid, MatrixStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        matrixStack.func_227861_a_(0.0, 0.4375, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotationYaw));
        float renderPitchOffset = MathHelper.func_219799_g((float)partialTicks, (float)squid.prevPitchOffset, (float)squid.pitchOffset);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(270.0f - squid.field_70125_A + renderPitchOffset));
        matrixStack.func_227861_a_(0.0, -0.5625, 0.0);
    }
}

