/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outerend.entities;

import blueduck.outerend.registry.ItemRegistry;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class EntombedEntity
extends MonsterEntity {
    public static final DataParameter<String> SKIN = EntityDataManager.func_187226_a(EntombedEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Float> ARM_SWING = EntityDataManager.func_187226_a(EntombedEntity.class, (IDataSerializer)DataSerializers.field_187193_c);

    public EntombedEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70699_by = new GroundPathNavigator((MobEntity)this, worldIn);
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.applyEntityAI();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKIN, (Object)"");
        this.field_70180_af.func_187214_a(ARM_SWING, (Object)Float.valueOf(0.0f));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (compound.func_74779_i("skin").equals("")) {
            if (this.field_70146_Z.nextInt(500) == 1) {
                compound.func_74778_a("skin", "amogus");
            } else {
                compound.func_74778_a("skin", "default");
            }
        } else {
            compound.func_74778_a("skin", (String)this.func_184212_Q().func_187225_a(SKIN));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (((String)this.func_184212_Q().func_187225_a(SKIN)).equals("")) {
            if (this.field_70146_Z.nextInt(500) == 1) {
                compound.func_74778_a("skin", "amogus");
            } else {
                compound.func_74778_a("skin", "default");
            }
        }
        this.field_70180_af.func_187227_b(SKIN, (Object)compound.func_74779_i("skin"));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (this.field_70146_Z.nextInt(500) == 1) {
            this.field_70180_af.func_187227_b(SKIN, (Object)"amogus");
        } else {
            this.field_70180_af.func_187227_b(SKIN, (Object)"default");
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void applyEntityAI() {
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{EntombedEntity.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, GolemEntity.class, 5, false, false, p_234199_0_ -> !(p_234199_0_ instanceof IMob)));
    }

    public static AttributeModifierMap createModifiers() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233826_i_, 0.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233818_a_, 20.0).func_233813_a_();
    }

    public Entity getNearest(Class<? extends LivingEntity> ... classes) {
        for (Class<? extends LivingEntity> clazz : classes) {
            LivingEntity e = this.field_70170_p.func_217360_a(clazz, EntityPredicate.field_221016_a.func_221014_c().func_221010_e().func_221012_a(entity -> {
                if (entity instanceof PlayerEntity) {
                    return !((PlayerEntity)entity).func_184812_l_();
                }
                return true;
            }), null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), new AxisAlignedBB(-16.0, -16.0, -16.0, 16.0, 16.0, 16.0).func_191194_a(this.func_213303_ch()));
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public void setSwingProgress(float amt) {
        this.field_70180_af.func_187227_b(ARM_SWING, (Object)Float.valueOf(amt));
    }

    public float getSwingProgress() {
        return ((Float)this.field_70180_af.func_187225_a(ARM_SWING)).floatValue();
    }

    public void incrementSwingProgress(float amt) {
        this.field_70180_af.func_187227_b(ARM_SWING, (Object)Float.valueOf(this.getSwingProgress() + amt));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getSwingProgress() != 0.0f) {
            this.incrementSwingProgress(0.15f);
            if (this.getSwingProgress() >= 2.0f) {
                this.setSwingProgress(0.0f);
            }
        }
        this.field_70143_R = 0.0f;
        this.func_70050_g(10);
    }

    public boolean func_70652_k(Entity entityIn) {
        this.setSwingProgress(0.1f);
        return super.func_70652_k(entityIn);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ItemRegistry.ENTOMBED_SPAWN_EGG.get());
    }

    public int func_70693_a(PlayerEntity player) {
        return player.func_130014_f_().func_201674_k().nextInt(25);
    }
}

