/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outerend.registry;

import blueduck.outerend.OuterEndMod;
import blueduck.outerend.structures.CatacombsStructure;
import blueduck.outerend.structures.EndTowerStructure;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class StructureRegistry {
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)OuterEndMod.MODID);
    public static final RegistryObject<Structure<NoFeatureConfig>> END_TOWER = StructureRegistry.setupStructure("end_tower", () -> new EndTowerStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> CATACOMBS = StructureRegistry.setupStructure("catacombs", () -> new CatacombsStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    private static <T extends Structure<?>> RegistryObject<T> setupStructure(String name, Supplier<T> structure) {
        return STRUCTURES.register(name, structure);
    }

    public static void init() {
        STRUCTURES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static void setupStructures() {
        StructureRegistry.setupStructure((Structure)END_TOWER.get(), new StructureSeparationSettings(OuterEndMod.CONFIG.END_TOWER_MAX.get().intValue(), OuterEndMod.CONFIG.END_TOWER_MIN.get().intValue(), 753937990), false);
        StructureRegistry.setupStructure((Structure)CATACOMBS.get(), new StructureSeparationSettings(OuterEndMod.CONFIG.CATACOMBS_MAX.get().intValue(), OuterEndMod.CONFIG.CATACOMBS_MIN.get().intValue(), 125261290), false);
    }

    public static <F extends Structure<?>> void setupStructure(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
    }
}

