/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.terraformersmc.terraform.shapes.impl.layer.transform;

import java.util.function.Predicate;
import net.minecraft.util.math.MathHelper;
import shadow.com.terraformersmc.terraform.shapes.api.Position;
import shadow.com.terraformersmc.terraform.shapes.api.Quaternion;
import shadow.com.terraformersmc.terraform.shapes.api.Shape;
import shadow.com.terraformersmc.terraform.shapes.api.layer.Layer;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.transform.RotateLayer;

public class BendLayer
implements Layer {
    private final double arc;
    private final double width;
    private final double height;

    public BendLayer(double arc, double width, double height) {
        this.arc = arc;
        this.width = width;
        this.height = height;
    }

    public static BendLayer of(double arc, double width, double height) {
        return new BendLayer(arc, width, height);
    }

    @Override
    public Position modifyMax(Shape shape) {
        Position pos = shape.max();
        pos.setY(MathHelper.func_219803_d((double)this.reverseLerp(0.0, 360.0, this.arc), (double)pos.getY(), (double)(this.width * 2.0)));
        return pos;
    }

    @Override
    public Position modifyMin(Shape shape) {
        Position pos = shape.min();
        pos.setX(pos.getX() - Math.sin(Math.toRadians(Math.min(this.arc, 145.0))) * this.height);
        double moss = this.modifyMax(shape).getY();
        pos.setY(-MathHelper.func_219803_d((double)this.reverseLerp(0.0, 360.0, this.arc), (double)moss, (double)(this.height - moss)));
        return pos;
    }

    @Override
    public Predicate<Position> modifyEquation(Shape shape) {
        return pos -> new RotateLayer(this.getRotation((Position)pos)).modifyEquation(shape).test((Position)pos);
    }

    private double getDist(Position pos) {
        return Math.sqrt(pos.getX() * pos.getX() + pos.getY() + pos.getY() + pos.getZ() + pos.getZ());
    }

    private Quaternion getRotation(Position pos) {
        return Quaternion.of(0.0, 0.0, this.arc * (this.getDist(pos) / this.height), true);
    }

    private double reverseLerp(double start, double end, double place) {
        return (place - start) / (end - start);
    }
}

