/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.terraformersmc.terraform.shapes.impl.layer.transform;

import java.util.Random;
import java.util.function.Predicate;
import shadow.com.terraformersmc.terraform.shapes.api.Position;
import shadow.com.terraformersmc.terraform.shapes.api.Shape;
import shadow.com.terraformersmc.terraform.shapes.api.layer.Layer;

public class NoiseTranslateLayer
implements Layer {
    private final double magnitude;
    private final Random random;

    public NoiseTranslateLayer(double magnitude, Random random) {
        this.magnitude = magnitude;
        this.random = random;
    }

    public static NoiseTranslateLayer of(double magnitude, Random random) {
        return new NoiseTranslateLayer(magnitude, random);
    }

    @Override
    public Position modifyMax(Shape shape) {
        Position pos = shape.max();
        pos.setX(pos.getX() + this.magnitude);
        pos.setY(pos.getY() + this.magnitude);
        pos.setZ(pos.getZ() + this.magnitude);
        return pos;
    }

    @Override
    public Position modifyMin(Shape shape) {
        Position pos = shape.min();
        pos.setX(pos.getX() - this.magnitude);
        pos.setY(pos.getY() - this.magnitude);
        pos.setZ(pos.getZ() - this.magnitude);
        return pos;
    }

    @Override
    public Predicate<Position> modifyEquation(Shape shape) {
        return pos -> {
            pos.setX(pos.getX() + (double)this.random.nextFloat() * this.magnitude - (double)this.random.nextFloat() * this.magnitude);
            pos.setY(pos.getY() + (double)this.random.nextFloat() * this.magnitude - (double)this.random.nextFloat() * this.magnitude);
            pos.setZ(pos.getZ() + (double)this.random.nextFloat() * this.magnitude - (double)this.random.nextFloat() * this.magnitude);
            return shape.equation().test((Position)pos);
        };
    }
}

